/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.resilience;

import com.atlassian.bitbucket.dmz.resilience.CircuitBreakerConfiguration;
import com.atlassian.stash.internal.resilience.ConfigurationAlreadyExistsException;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class R4JApiWrapper {
    public static final String CALLS_IN_HALF_OPEN = "circuit.breaker.default.allowed.calls.in.half.open";
    public static final String FAIL_THRESHOLD = "circuit.breaker.default.fail.threshold";
    public static final String MINIMUM_NUM_CALLS = "circuit.breaker.default.minimum.number.of.calls";
    public static final String OPEN_DURATION = "circuit.breaker.default.open.duration";
    public static final String SLOW_THRESHOLD = "circuit.breaker.default.slow.threshold";
    public static final String WINDOW_SIZE = "circuit.breaker.default.window.size";
    public static final String WRITE_STACK_TRACES = "circuit.breaker.default.write.stacktraces.enabled";
    private static final Logger log = LoggerFactory.getLogger(R4JApiWrapper.class);
    private final CircuitBreakerRegistry registry;

    @Autowired
    public R4JApiWrapper(InternalApplicationPropertiesService propertiesService) {
        this.registry = CircuitBreakerRegistry.of((CircuitBreakerConfig)CircuitBreakerConfig.custom().enableAutomaticTransitionFromOpenToHalfOpen().failureRateThreshold((float)propertiesService.getProperty(FAIL_THRESHOLD, 60)).permittedNumberOfCallsInHalfOpenState(propertiesService.getProperty(CALLS_IN_HALF_OPEN, 10)).slidingWindow(propertiesService.getProperty(WINDOW_SIZE, 100), propertiesService.getProperty(MINIMUM_NUM_CALLS, 5), CircuitBreakerConfig.SlidingWindowType.COUNT_BASED).slowCallDurationThreshold(Duration.ofSeconds(propertiesService.getProperty(SLOW_THRESHOLD, 30))).waitDurationInOpenState(Duration.ofSeconds(propertiesService.getProperty(OPEN_DURATION, 60))).writableStackTraceEnabled(propertiesService.getProperty(WRITE_STACK_TRACES, true)).build());
    }

    public void createConfiguration(@Nonnull CircuitBreakerConfiguration config) {
        Objects.requireNonNull(config, "config");
        if (!config.isEnabled()) {
            log.debug("Skipping adding config {} as it is disabled", (Object)config.getName());
            return;
        }
        if (this.registry.getConfiguration(config.getName()).isPresent()) {
            throw new ConfigurationAlreadyExistsException(String.format("Configuration with name %s already exists", config.getName()));
        }
        this.registry.addConfiguration(config.getName(), (Object)this.toR4JConfig(config, (CircuitBreakerConfig)this.registry.getDefaultConfig()));
    }

    @Nonnull
    public List<CircuitBreaker> getCircuitBreakers() {
        return this.registry.getAllCircuitBreakers().toJavaList();
    }

    @Nonnull
    public Optional<CircuitBreakerConfiguration> getConfiguration(@Nonnull String name) {
        Objects.requireNonNull(name, "name");
        return this.registry.getConfiguration(name.toLowerCase(Locale.ROOT)).map(config -> this.toCircuitBreakerConfiguration(name, (CircuitBreakerConfig)config));
    }

    @Nonnull
    public CircuitBreaker getOrCreateCircuitBreaker(@Nonnull String name, @Nonnull String configName) {
        String lowercaseName = Objects.requireNonNull(name, "name").toLowerCase(Locale.ROOT);
        String lowercaseConfigName = Objects.requireNonNull(configName, "configName").toLowerCase(Locale.ROOT);
        return this.registry.getConfiguration(lowercaseConfigName).map(config -> this.registry.circuitBreaker(lowercaseName, lowercaseConfigName)).orElseGet(() -> {
            CircuitBreaker circuitBreaker = this.registry.circuitBreaker(lowercaseName);
            circuitBreaker.transitionToForcedOpenState();
            return circuitBreaker;
        });
    }

    private CircuitBreakerConfiguration toCircuitBreakerConfiguration(String name, CircuitBreakerConfig config) {
        return new CircuitBreakerConfiguration.Builder(name).failureThreshold(config.getFailureRateThreshold()).numberOfCallsInHalfOpen(config.getPermittedNumberOfCallsInHalfOpenState()).windowSize(config.getSlidingWindowSize()).minimumCallsRequired(config.getMinimumNumberOfCalls()).slowCallThreshold(config.getSlowCallDurationThreshold()).waitInOpenState(config.getWaitDurationInOpenState()).writeStackTraces(config.isWritableStackTraceEnabled()).build();
    }

    private CircuitBreakerConfig toR4JConfig(CircuitBreakerConfiguration config, CircuitBreakerConfig defaultConfig) {
        return CircuitBreakerConfig.custom().enableAutomaticTransitionFromOpenToHalfOpen().ignoreException(config.getExceptionsToIgnore()).failureRateThreshold(config.getOrDefaultFailureThreshold(defaultConfig.getFailureRateThreshold())).permittedNumberOfCallsInHalfOpenState(config.getOrDefaultNumberOfCallsInHalfOpen(defaultConfig.getPermittedNumberOfCallsInHalfOpenState())).slidingWindowSize(config.getOrDefaultWindowSize(defaultConfig.getSlidingWindowSize())).slidingWindowType(CircuitBreakerConfig.SlidingWindowType.COUNT_BASED).minimumNumberOfCalls(config.getOrDefaultMinimumCallsRequired(defaultConfig.getMinimumNumberOfCalls())).slowCallDurationThreshold(config.getOrDefaultSlowCallThreshold(defaultConfig.getSlowCallDurationThreshold())).waitDurationInOpenState(config.getOrDefaultWaitInOpenState(defaultConfig.getWaitDurationInOpenState())).writableStackTraceEnabled(config.isWriteStackTraces()).build();
    }
}

