/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=ApplicationProperties.class)
@Component(value="applicationProperties")
public class DefaultApplicationProperties
implements ApplicationProperties {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final NavBuilder navBuilder;
    private final RequestManager requestManager;
    private final StorageService storageService;

    @Autowired
    public DefaultApplicationProperties(ApplicationPropertiesService applicationPropertiesService, NavBuilder navBuilder, RequestManager requestManager, StorageService storageService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.navBuilder = navBuilder;
        this.requestManager = requestManager;
        this.storageService = storageService;
    }

    @Nonnull
    public String getApplicationFileEncoding() {
        return "UTF-8";
    }

    @Deprecated
    public String getBaseUrl() {
        return this.navBuilder.buildBaseUrl();
    }

    @Nonnull
    public String getBaseUrl(UrlMode urlMode) {
        if (urlMode == UrlMode.AUTO) {
            urlMode = this.requestManager.getRequestContext() == null ? UrlMode.CANONICAL : UrlMode.RELATIVE;
        }
        switch (urlMode) {
            case CANONICAL: {
                return this.navBuilder.buildConfigured();
            }
            case ABSOLUTE: {
                return this.navBuilder.buildAbsolute();
            }
            case RELATIVE: {
                return this.navBuilder.buildRelative();
            }
            case RELATIVE_CANONICAL: {
                URI configured = this.applicationPropertiesService.getBaseUrl();
                return configured == null ? null : configured.getRawPath();
            }
            case AUTO: {
                throw new IllegalStateException("UrlMode.AUTO should have been rewritten to either CANONICAL or RELATIVE");
            }
        }
        return this.navBuilder.buildBaseUrl();
    }

    @Nonnull
    public Date getBuildDate() {
        return this.applicationPropertiesService.getBuildTimestamp();
    }

    @Nonnull
    public String getBuildNumber() {
        return this.applicationPropertiesService.getBuildNumber();
    }

    @Nonnull
    public String getDisplayName() {
        return Product.NAME;
    }

    @Deprecated
    public File getHomeDirectory() {
        return this.storageService.getHomeDir().toFile();
    }

    @Nonnull
    public Optional<Path> getLocalHomeDirectory() {
        return Optional.of(this.storageService.getHomeDir());
    }

    @Nonnull
    public String getPlatformId() {
        return "bitbucket";
    }

    @Deprecated
    public String getPropertyValue(String key) {
        return this.applicationPropertiesService.getPluginProperty(key);
    }

    @Nonnull
    public Optional<Path> getSharedHomeDirectory() {
        return Optional.of(this.storageService.getSharedHomeDir());
    }

    @Nonnull
    public String getVersion() {
        return this.applicationPropertiesService.getBuildVersion();
    }
}

