/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal;

import com.atlassian.bitbucket.timezone.TimeZoneService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.stash.internal.user.InternalUserService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=TimeZoneManager.class)
@Component
public class DefaultTimeZoneManager
implements TimeZoneManager {
    private final InternalUserService userService;
    private final TimeZoneService timeZoneService;

    @Autowired
    public DefaultTimeZoneManager(InternalUserService userService, TimeZoneService timeZoneService) {
        this.userService = userService;
        this.timeZoneService = timeZoneService;
    }

    @Nonnull
    public TimeZone getUserTimeZone() {
        return TimeZone.getTimeZone(this.timeZoneService.getTimeZone());
    }

    @Nonnull
    public TimeZone getUserTimeZone(@Nonnull UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        ApplicationUser user = this.userService.getUserByKey(userKey);
        if (user == null) {
            return this.getDefaultTimeZone();
        }
        return TimeZone.getTimeZone(this.timeZoneService.getTimeZone(user));
    }

    @Nonnull
    public TimeZone getDefaultTimeZone() {
        return TimeZone.getTimeZone(this.timeZoneService.getDefaultTimeZone());
    }
}

