/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.language.Language;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.atlassian.stash.internal.user.InternalUserService;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="stashLocaleResolver")
@AvailableToPlugins(value=LocaleResolver.class)
public class StashLocaleResolver
implements LocaleResolver {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final InternalLanguageService languageService;
    private final LocaleHolder localeHolder;
    private final InternalLocaleManager localeManager;
    private final InternalUserService userService;

    @Autowired
    public StashLocaleResolver(ApplicationPropertiesService applicationPropertiesService, InternalLanguageService languageService, LocaleHolder localeHolder, InternalLocaleManager localeManager, InternalUserService userService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.languageService = languageService;
        this.localeHolder = localeHolder;
        this.localeManager = localeManager;
        this.userService = userService;
    }

    public Locale getApplicationLocale() {
        return this.applicationPropertiesService.getLocale();
    }

    public Locale getLocale(HttpServletRequest request) {
        return this.getLocale();
    }

    public Locale getLocale() {
        return this.processLocale((Locale)Iterables.getFirst((Iterable)this.localeHolder.getLocales(new Locale[0]), null));
    }

    public Locale getLocale(@Nullable UserKey userKey) {
        ApplicationUser user = this.userService.getUserByKey(userKey);
        return this.processLocale(user != null ? this.localeManager.getLocale(user) : null);
    }

    public Set<Locale> getSupportedLocales() {
        return Chainable.chain((Iterable)this.languageService.getLanguages()).transform(Language::getLocale).toSet();
    }

    private Locale processLocale(Locale locale) {
        return (Locale)MoreObjects.firstNonNull((Object)locale, (Object)Locale.getDefault());
    }
}

