/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserProfile;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Objects;

public class DefaultUserProfile
implements UserProfile {
    private static final int DEFAULT_AVATAR_SIZE = 128;
    private final AvatarService avatarService;
    private final NavBuilder navBuilder;
    private final ApplicationUser user;

    public DefaultUserProfile(@Nonnull ApplicationUser user, @Nonnull NavBuilder navBuilder, @Nonnull AvatarService avatarService) {
        this.avatarService = Objects.requireNonNull(avatarService, "avatarService");
        this.navBuilder = Objects.requireNonNull(navBuilder, "navBuilder");
        this.user = Objects.requireNonNull(user, "user");
    }

    public String getEmail() {
        return this.user.getEmailAddress();
    }

    public String getFullName() {
        return this.user.getDisplayName();
    }

    public UserKey getUserKey() {
        return UserKey.fromLong((long)this.user.getId());
    }

    public String getUsername() {
        return this.user.getName();
    }

    public URI getProfilePictureUri(int width, int height) {
        return this.getUrlForPerson(width);
    }

    public URI getProfilePictureUri() {
        return this.getUrlForPerson(128);
    }

    public URI getProfilePageUri() {
        return URI.create(this.navBuilder.user(this.user).buildRelNoContext());
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUserProfile that = (DefaultUserProfile)o;
        return ApplicationUserEquality.equals((ApplicationUser)this.getUser(), (Object)that.getUser());
    }

    public int hashCode() {
        return this.user.hashCode();
    }

    protected URI getUrlForPerson(int width) {
        boolean useHttps = this.navBuilder.buildBaseUrl().startsWith("https");
        String avatarUrl = this.avatarService.getUrlForPerson((Person)this.user, new AvatarRequest(useHttps, width));
        return UrlUtils.uncheckedCreateURI((String)avatarUrl);
    }
}

