/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.sal.user.DelegatingUserSettings;
import com.atlassian.stash.internal.sal.user.MapUserSettingsBuilder;
import com.atlassian.stash.internal.setting.SettingsHelper;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.internal.user.InternalUserSettings;
import com.atlassian.stash.internal.user.InternalUserSettingsService;
import com.atlassian.stash.internal.user.UserSettingsDao;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=UserSettingsService.class)
@Service(value="userSettingsService")
public class DefaultUserSettingsService
extends AbstractService
implements InternalUserSettingsService {
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final SettingsHelper settingsHelper;
    private final InternalUserService userService;
    private final UserSettingsDao userSettingsDao;

    @Autowired
    public DefaultUserSettingsService(@Nonnull InternalUserService userService, @Nonnull UserSettingsDao userSettingsDao, @Nonnull SettingsHelper settingsHelper, @Nonnull PermissionService permissionService, @Nonnull I18nService i18nService) {
        this.userService = userService;
        this.userSettingsDao = userSettingsDao;
        this.settingsHelper = settingsHelper;
        this.permissionService = permissionService;
        this.i18nService = i18nService;
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserSettings getUserSettings(UserKey userKey) {
        if (userKey == null) {
            return null;
        }
        return this.getUserSettings(this.checkUser(this.userService.getUserByKey(userKey, true)));
    }

    @Unsecured(value="Internal service method")
    public UserSettings getUserSettings(ApplicationUser user) {
        if (user == null) {
            return null;
        }
        InternalUserSettings internalUserSettings = (InternalUserSettings)this.userSettingsDao.getById((Object)user.getId());
        MapUserSettingsBuilder builder = new MapUserSettingsBuilder();
        if (internalUserSettings != null) {
            builder.putAll(this.settingsHelper.deserialize(internalUserSettings.getSettings().getData()));
        }
        return builder.build();
    }

    @Secured(value="Secured using a code permission check")
    @Transactional
    public void updateUserSettings(UserKey userKey, Function<UserSettingsBuilder, UserSettings> updateFunction) {
        Objects.requireNonNull(userKey, "userKey");
        Objects.requireNonNull(updateFunction, "updateFunction");
        this.updateUserSettings(this.checkUserAndPermissions(this.userService.getUserByKey(userKey, true)), updateFunction);
    }

    @Transactional
    @Unsecured(value="Internal service method")
    public void updateUserSettings(@Nonnull ApplicationUser user, @Nonnull Function<UserSettingsBuilder, UserSettings> updateFunction) {
        Objects.requireNonNull(user, "user");
        InternalUserSettings currentSettings = (InternalUserSettings)this.userSettingsDao.getById((Object)user.getId());
        MapUserSettingsBuilder userSettingsBuilder = new MapUserSettingsBuilder();
        if (currentSettings != null) {
            Settings settings = this.settingsHelper.deserialize(currentSettings.getSettings().getData());
            userSettingsBuilder.putAll(settings);
        }
        DelegatingUserSettings newSettings = (DelegatingUserSettings)updateFunction.apply(userSettingsBuilder);
        InternalUserSettings.Builder builder = currentSettings == null ? new InternalUserSettings.Builder().user(InternalConverter.convertToInternalUser((ApplicationUser)user)) : new InternalUserSettings.Builder(currentSettings);
        this.userSettingsDao.update((Object)builder.settings(this.settingsHelper.serialize(newSettings.getSettings())).build());
    }

    private ApplicationUser checkUser(ApplicationUser user) {
        if (user == null) {
            throw new IllegalArgumentException(this.i18nService.createKeyedMessage("bitbucket.service.user.settings.nosuchuser", new Object[0]).getLocalisedMessage());
        }
        return user;
    }

    private ApplicationUser checkUserAndPermissions(ApplicationUser user) {
        this.checkUser(user);
        if (!this.permissionService.hasUserPermission(user, Permission.USER_ADMIN)) {
            KeyedMessage keyedMessage = this.i18nService.createKeyedMessage("bitbucket.service.user.settings.unauthorized", new Object[]{user.getDisplayName()});
            throw new AuthorisationException(keyedMessage);
        }
        return user;
    }
}

