/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.user;

import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.util.Objects;
import java.util.Set;

public class DelegatingUserSettings
implements UserSettings {
    private final Settings settings;

    DelegatingUserSettings(Settings settings) {
        this.settings = Objects.requireNonNull(settings, "settings");
    }

    public Option<String> getString(String key) {
        try {
            return Option.option((Object)this.settings.getString(this.checkKey(key)));
        }
        catch (ClassCastException e) {
            return Option.none();
        }
    }

    public Option<Boolean> getBoolean(String key) {
        try {
            return Option.option((Object)this.settings.getBoolean(this.checkKey(key)));
        }
        catch (ClassCastException e) {
            return Option.none();
        }
    }

    public Option<Long> getLong(String key) {
        try {
            return Option.option((Object)this.settings.getLong(this.checkKey(key)));
        }
        catch (ClassCastException | NumberFormatException e) {
            return Option.none();
        }
    }

    public Set<String> getKeys() {
        return this.settings.asMap().keySet();
    }

    public Settings getSettings() {
        return this.settings;
    }

    private String checkKey(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        Preconditions.checkArgument((key.length() <= UserSettingsService.MAX_KEY_LENGTH ? 1 : 0) != 0, (String)"key cannot be longer than %s characters", (int)UserSettingsService.MAX_KEY_LENGTH);
        return key;
    }
}

