/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.ScmFeature;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AbstractOptionalCommandFactory<C> {
    protected final Repository repository;
    private final C commandFactory;
    private final UnsupportedFeatureHandler featureUnsupported;

    AbstractOptionalCommandFactory(@Nonnull Repository repository, @Nullable C commandFactory, @Nonnull UnsupportedFeatureHandler featureUnsupported) {
        this.commandFactory = commandFactory;
        this.featureUnsupported = Objects.requireNonNull(featureUnsupported, "featureUnsupported");
        this.repository = Objects.requireNonNull(repository, "repository");
    }

    @Nonnull
    <T> Command<T> getCommandOrThrowUnsupported(ScmFeature feature, Function<C, Command<T>> factory) {
        Command<T> command;
        try {
            command = this.commandFactory == null ? null : factory.apply(this.commandFactory);
        }
        catch (UnsupportedOperationException e) {
            command = null;
        }
        if (command == null) {
            throw (FeatureUnsupportedScmException)((Object)this.featureUnsupported.apply(this.repository.getScmId(), feature));
        }
        return command;
    }

    @FunctionalInterface
    public static interface UnsupportedFeatureHandler
    extends BiFunction<String, ScmFeature, FeatureUnsupportedScmException> {
    }
}

