/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.internal.scm.InternalScmService;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Throttled(value="scm-command")
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public abstract class AbstractScmService
extends AbstractService {
    @Value(value="${commit.diff.context}")
    protected int diffContext;
    @Value(value="${page.max.changes}")
    protected int maxChanges;
    @Value(value="${page.max.commits}")
    protected int maxCommits;
    @Value(value="${page.max.diff.lines}")
    protected int maxDiffLines;
    @Value(value="${page.max.directory.children}")
    protected int maxDirectoryChildren;
    @Value(value="${page.max.directory.recursive.children}")
    protected int maxDirectoryRecursiveChildren;
    @Value(value="${page.max.source.length}")
    protected int maxLineLength;
    @Value(value="${page.max.source.lines}")
    protected int maxSourceLines;
    protected final InternalScmService scmService;

    protected AbstractScmService(InternalScmService scmService) {
        this.scmService = Objects.requireNonNull(scmService, "scmService");
    }

    protected ScmCommandFactory getCommandFactory(@Nonnull Repository repository) {
        return this.scmService.getCommandFactory(Objects.requireNonNull(repository, "repository"));
    }
}

