/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.repository.TagCallback;
import com.atlassian.bitbucket.scm.BlameCommandParameters;
import com.atlassian.bitbucket.scm.BranchesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesetsCommandParameters;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.CommonAncestorCommandParameters;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.DiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.DirectoryCommandParameters;
import com.atlassian.bitbucket.scm.FileCommandParameters;
import com.atlassian.bitbucket.scm.IncompleteScmException;
import com.atlassian.bitbucket.scm.PluginCommandFactory;
import com.atlassian.bitbucket.scm.RawFileCommandParameters;
import com.atlassian.bitbucket.scm.RefsCommandParameters;
import com.atlassian.bitbucket.scm.RepositorySize;
import com.atlassian.bitbucket.scm.RepositorySizeCommandParameters;
import com.atlassian.bitbucket.scm.ResolveCommitsCommandParameters;
import com.atlassian.bitbucket.scm.ResolveRefCommandParameters;
import com.atlassian.bitbucket.scm.ResolveRefsCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.SizeCommandParameters;
import com.atlassian.bitbucket.scm.TagsCommandParameters;
import com.atlassian.bitbucket.scm.TypeCommandParameters;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class PluginScmCommandFactory
implements ScmCommandFactory {
    private final PluginCommandFactory commandFactory;
    private final IncompleteScmHandler incompleteScm;
    private final Repository repository;

    public PluginScmCommandFactory(Repository repository, PluginCommandFactory commandFactory, IncompleteScmHandler incompleteScm) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.commandFactory = Objects.requireNonNull(commandFactory, "commandFactory");
        this.incompleteScm = Objects.requireNonNull(incompleteScm);
    }

    @Nonnull
    public Command<Page<Blame>> blame(@Nonnull BlameCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.blame(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> branches(@Nonnull BranchesCommandParameters parameters, @Nonnull BranchCallback callback) {
        return this.commandFactory.branches(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Page<Branch>> branches(@Nonnull BranchesCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.branches(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> changes(@Nonnull ChangesCommandParameters parameters, @Nonnull ChangeCallback callback) {
        return this.commandFactory.changes(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Page<Change>> changes(@Nonnull ChangesCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.changes(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Page<Changeset>> changesets(@Nonnull ChangesetsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.changesets(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<MinimalCommit> commonAncestor(@Nonnull CommonAncestorCommandParameters parameters) {
        return this.commandFactory.commonAncestor(this.repository, parameters);
    }

    @Nonnull
    public Command<Commit> commit(@Nonnull CommitCommandParameters parameters) {
        return this.commandFactory.commit(this.repository, parameters);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull CommitsCommandParameters parameters, @Nonnull CommitCallback callback) {
        return this.commandFactory.commits(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Page<Commit>> commits(@Nonnull CommitsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.commits(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Branch> defaultBranch() {
        return this.commandFactory.defaultBranch(this.repository);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull DiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull DiffCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        return this.getCommandOrThrowIncompleteScm(commandFactory -> commandFactory.diff(this.repository, parameters, outputSupplier));
    }

    @Nonnull
    public Command<DiffStatsSummary> diffStatsSummary(@Nonnull DiffStatsSummaryCommandParameters parameters) {
        return this.commandFactory.diffStatsSummary(this.repository, parameters);
    }

    @Nonnull
    public Command<Void> directory(@Nonnull DirectoryCommandParameters parameters, @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.directory(this.repository, parameters, callback, pageRequest);
    }

    @Nonnull
    public Command<Void> file(@Nonnull FileCommandParameters parameters, @Nonnull FileContentCallback callback, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.file(this.repository, parameters, callback, pageRequest);
    }

    @Nonnull
    public Command<Void> rawFile(@Nonnull RawFileCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        return this.commandFactory.rawFile(this.repository, parameters, outputSupplier);
    }

    @Nonnull
    public Command<Void> refs(@Nonnull RefsCommandParameters parameters, @Nonnull RefCallback callback) {
        return this.commandFactory.refs(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<RepositorySize> repositorySize(@Nonnull Repository repository, @Nonnull RepositorySizeCommandParameters parameters) {
        return this.commandFactory.repositorySize(repository, parameters);
    }

    @Nonnull
    public Command<Map<String, String>> resolveCommits(@Nonnull ResolveCommitsCommandParameters parameters) {
        return this.commandFactory.resolveCommits(this.repository, parameters);
    }

    @Nonnull
    public Command<Ref> resolveRef(@Nonnull ResolveRefCommandParameters parameters) {
        return this.commandFactory.resolveRef(this.repository, parameters);
    }

    @Nonnull
    public Command<Map<String, Ref>> resolveRefs(@Nonnull ResolveRefsCommandParameters parameters) {
        return this.commandFactory.resolveRefs(this.repository, parameters);
    }

    @Nonnull
    public Command<Long> size(@Nonnull SizeCommandParameters parameters) {
        return this.commandFactory.size(this.repository, parameters);
    }

    @Nonnull
    public Command<Void> tags(@Nonnull TagsCommandParameters parameters, @Nonnull TagCallback callback) {
        return this.commandFactory.tags(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Page<Tag>> tags(@Nonnull TagsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.tags(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> traverseCommits(@Nonnull TraversalCallback callback) {
        return this.commandFactory.traverseCommits(this.repository, callback);
    }

    @Nonnull
    public Command<ContentTreeNode.Type> type(@Nonnull TypeCommandParameters parameters) {
        return this.commandFactory.type(this.repository, parameters);
    }

    @Nonnull
    <T> Command<T> getCommandOrThrowIncompleteScm(Function<PluginCommandFactory, Command<T>> factory) {
        try {
            return factory.apply(this.commandFactory);
        }
        catch (LinkageError e) {
            throw (IncompleteScmException)this.incompleteScm.apply(this.repository.getScmId());
        }
    }

    @FunctionalInterface
    public static interface IncompleteScmHandler
    extends Function<String, IncompleteScmException> {
    }
}

