/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.compare.CompareChangeCommandParameters;
import com.atlassian.bitbucket.scm.compare.CompareDiffCommandParameters;
import com.atlassian.bitbucket.scm.compare.CompareDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.compare.PluginCompareCommandFactory;
import com.atlassian.bitbucket.scm.compare.ScmCompareCommandFactory;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class PluginScmCompareCommandFactory
implements ScmCompareCommandFactory {
    private final CompareRequest compareRequest;
    private final PluginCompareCommandFactory commandFactory;

    public PluginScmCompareCommandFactory(CompareRequest compareRequest, PluginCompareCommandFactory commandFactory) {
        this.compareRequest = Objects.requireNonNull(compareRequest, "compareRequest");
        this.commandFactory = Objects.requireNonNull(commandFactory, "commandFactory");
    }

    @Nonnull
    public Command<Void> changes(@Nonnull CompareChangeCommandParameters parameters, @Nonnull ChangeCallback callback) {
        return this.commandFactory.changes(this.compareRequest, parameters, callback);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull CommitCallback callback) {
        return this.commandFactory.commits(this.compareRequest, callback);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull CompareDiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.compareRequest, parameters, callback);
    }

    @Nonnull
    public Command<DiffStatsSummary> diffStatsSummary(@Nonnull CompareDiffStatsSummaryCommandParameters parameters) {
        return this.commandFactory.diffStatsSummary(this.compareRequest, parameters);
    }
}

