/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffStatsSummary;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeResult;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.pull.PluginPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.pull.PullRequestAcceptMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestChangesCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestCommitsCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestDiffStatsSummaryCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.scm.pull.PullRequestMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.PullRequestPrepareMergeCommandParameters;
import com.atlassian.bitbucket.scm.pull.ScmPullRequestCommandFactory;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class PluginScmPullRequestCommandFactory
implements ScmPullRequestCommandFactory {
    private final PluginPullRequestCommandFactory commandFactory;
    private final PullRequest pullRequest;

    public PluginScmPullRequestCommandFactory(PullRequest pullRequest, PluginPullRequestCommandFactory commandFactory) {
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        this.commandFactory = Objects.requireNonNull(commandFactory, "commandFactory");
    }

    @Nonnull
    public Command<Branch> acceptMerge(@Nonnull PullRequestAcceptMergeCommandParameters parameters) {
        return this.commandFactory.acceptMerge(this.pullRequest, parameters);
    }

    @Nonnull
    public Command<Void> changes(@Nonnull PullRequestChangesCommandParameters parameters, @Nonnull ChangeCallback callback) {
        return this.commandFactory.changes(this.pullRequest, parameters, callback);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull PullRequestCommitsCommandParameters parameters, @Nonnull CommitCallback callback) {
        return this.commandFactory.commits(this.pullRequest, parameters, callback);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull PullRequestDiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.pullRequest, parameters, callback);
    }

    @Nonnull
    public Command<DiffStatsSummary> diffStatsSummary(@Nonnull PullRequestDiffStatsSummaryCommandParameters parameters) {
        return this.commandFactory.diffStatsSummary(this.pullRequest, parameters);
    }

    @Nonnull
    public Command<PullRequestEffectiveDiff> effectiveDiff() {
        return this.commandFactory.effectiveDiff(this.pullRequest);
    }

    @Nonnull
    public Command<Branch> merge(@Nonnull PullRequestMergeCommandParameters parameters) {
        return this.commandFactory.merge(this.pullRequest, parameters);
    }

    @Nonnull
    public Command<Branch> prepareMerge(@Nonnull PullRequestPrepareMergeCommandParameters parameters) {
        return this.commandFactory.prepareMerge(this.pullRequest, parameters);
    }

    @Nonnull
    public Command<PullRequestMergeResult> tryMerge(@Nonnull PullRequest pullRequest) {
        return this.commandFactory.tryMerge(pullRequest);
    }
}

