/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secrets;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.bitbucket.dmz.secrets.DmzSecretService;
import com.atlassian.bitbucket.dmz.secrets.LazySecretDao;
import com.atlassian.bitbucket.dmz.secrets.SecretNamespace;
import com.atlassian.bitbucket.dmz.secrets.SecretServiceConfig;
import com.atlassian.bitbucket.util.ValueWrapper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceConfiguration;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.stash.internal.secrets.InternalSecretServiceProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Service;

@AvailableToPlugins(interfaces={DmzSecretService.class, SecretService.class})
@Service(value="secretService")
public class BitbucketSecretService
implements DmzSecretService,
ApplicationContextAware {
    private final ClusterLockService clusterLockService;
    private final SecretService delegate;
    private final LazySecretDao lazySecretDao;
    private final SecretServiceConfig secretServiceConfig;
    private final Cache<String, ValueWrapper<String>> unsealedSecretsCache;

    @Autowired
    public BitbucketSecretService(CacheFactory cacheFactory, ClusterLockService clusterLockService, LazySecretDao lazySecretDao, InternalSecretServiceProvider secretServiceProvider, SecretServiceConfig secretServiceConfig) {
        this.clusterLockService = clusterLockService;
        this.delegate = secretServiceProvider.getInternalSecretServiceUnsafe();
        this.lazySecretDao = lazySecretDao;
        this.secretServiceConfig = secretServiceConfig;
        CacheLoader<String, ValueWrapper<String>> cacheLoader = new CacheLoader<String, ValueWrapper<String>>(){

            @Nonnull
            public ValueWrapper<String> load(@Nonnull String namespacedIdentifier) {
                return new ValueWrapper((Serializable)((Object)((String)BitbucketSecretService.this.delegate.get(namespacedIdentifier).orElse(null))));
            }
        };
        this.unsealedSecretsCache = cacheFactory.getCache(BitbucketSecretService.class.getName(), (CacheLoader)cacheLoader, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build());
    }

    public void delete(@Nonnull String identifier) throws SecretServiceException {
        this.delete(SecretNamespace.EXTERNAL, identifier);
    }

    public void delete(@Nonnull SecretNamespace namespace, @Nonnull String identifier) throws SecretServiceException {
        Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(identifier, "identifier");
        String namespacedIdentifier = namespace.apply(identifier);
        this.delegate.delete(namespacedIdentifier);
        this.unsealedSecretsCache.remove((Object)namespacedIdentifier);
    }

    @Nonnull
    public Optional<String> get(@Nonnull String identifier) throws SecretServiceException {
        return this.get(SecretNamespace.EXTERNAL, identifier);
    }

    @Nonnull
    public Optional<String> get(@Nonnull SecretNamespace namespace, @Nonnull String identifier) throws SecretServiceException {
        Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(identifier, "identifier");
        try {
            ValueWrapper cacheValue = (ValueWrapper)this.unsealedSecretsCache.get((Object)namespace.apply(identifier));
            return Optional.ofNullable(cacheValue).map(ValueWrapper::get);
        }
        catch (CacheException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new SecretServiceException(cause.getMessage(), cause);
        }
    }

    @Nonnull
    public SecretServiceConfiguration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public SecretService.SecretServiceManagement getManagement() {
        return this.delegate.getManagement();
    }

    public void put(@Nonnull String identifier, @Nonnull String secretData) throws SecretServiceException {
        this.put(SecretNamespace.EXTERNAL, identifier, secretData);
    }

    public void put(@Nonnull SecretNamespace namespace, @Nonnull String identifier, @Nonnull String secretData) throws SecretServiceException {
        Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(secretData, "secretData");
        Preconditions.checkArgument((secretData.length() >= this.secretServiceConfig.getMinValueSize() ? 1 : 0) != 0, (Object)("secretData cannot be less than " + this.secretServiceConfig.getMinValueSize() + " characters"));
        Preconditions.checkArgument((secretData.length() <= this.secretServiceConfig.getMaxValueSize() ? 1 : 0) != 0, (Object)("secretData cannot be greater than " + this.secretServiceConfig.getMaxValueSize() + " characters"));
        String namespacedIdentifier = namespace.apply(identifier);
        this.delegate.put(namespacedIdentifier, secretData);
        this.unsealedSecretsCache.remove((Object)namespacedIdentifier);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContext applicationContext2 = applicationContext.getParent();
        if (applicationContext2 instanceof GenericApplicationContext) {
            GenericApplicationContext parentContext = (GenericApplicationContext)applicationContext2;
            parentContext.registerBean(LazySecretDao.class, () -> this.lazySecretDao, new BeanDefinitionCustomizer[0]);
            parentContext.registerBean(ClusterLockService.class, () -> this.clusterLockService, new BeanDefinitionCustomizer[0]);
            return;
        }
        throw new IllegalStateException("ApplicationContext is not a GenericApplicationContext");
    }
}

