/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secrets;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.secrets.DmzSecretService;
import com.atlassian.bitbucket.dmz.secrets.SecretNamespace;
import com.atlassian.bitbucket.dmz.secrets.SecretServiceConfig;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.DataSourceConfigurationSavedEvent;
import com.atlassian.stash.internal.config.SecuredConfigurationPropertyCallback;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="configurationFileSecretsManager")
public class ConfigurationFileSecretsManager
implements SecuredConfigurationPropertyCallback {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);
    private static final Set<String> JDBC_PROPS = ImmutableSet.of((Object)"jdbc.driver", (Object)"jdbc.password", (Object)"jdbc.url", (Object)"jdbc.user");
    private static final String LOCK_NAME = ConfigurationFileSecretsManager.class.getSimpleName();
    private final ConfigurationService configurationService;
    private final LockService lockService;
    private final DmzSecretService secretService;
    private final SecretServiceConfig secretServiceConfig;

    @Autowired
    public ConfigurationFileSecretsManager(ConfigurationService configurationService, LockService lockService, DmzSecretService secretService, SecretServiceConfig secretServiceConfig) {
        this.configurationService = configurationService;
        this.lockService = lockService;
        this.secretService = secretService;
        this.secretServiceConfig = secretServiceConfig;
    }

    @PostConstruct
    public void initialize() {
        if (this.secretServiceConfig.isDisabled()) {
            log.debug("Secret service is disabled, not securing configuration file");
            return;
        }
        if (this.secretServiceConfig.getSecuredProperties().isEmpty()) {
            log.debug("No secret properties configured, not securing configuration file");
            return;
        }
        log.debug("Securing secret properties in configuration file");
        this.secureConfigProperties();
    }

    @EventListener
    public void onDataSourceConfigurationSaved(DataSourceConfigurationSavedEvent event) {
        if (this.secretServiceConfig.isDisabled()) {
            log.debug("Secret service is disabled, not securing configuration file");
            return;
        }
        if (Sets.intersection(JDBC_PROPS, (Set)this.secretServiceConfig.getSecuredProperties()).isEmpty()) {
            log.debug("JDBC properties are not included in secured list, not securing configuration file");
            return;
        }
        log.debug("Data source configuration updated, securing secret properties in configuration file");
        this.secureConfigProperties();
    }

    public void onPropertySecured(@Nonnull String key, @Nonnull String value) {
        if (this.secretServiceConfig.isDisabled()) {
            throw new IllegalStateException("Secret service is in read-only mode");
        }
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.secretService.put(SecretNamespace.ENVIRONMENT, key, value);
    }

    private void secureConfigProperties() {
        try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_NAME));){
            if (guard == null) {
                log.debug("Unable to acquire lock for securing the configuration file. The task may be already running on another node.");
                return;
            }
            this.configurationService.secureSecretProperties((SecuredConfigurationPropertyCallback)this, this.secretServiceConfig.getSecuredProperties());
        }
    }
}

