/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.secrets;

import com.atlassian.bitbucket.dmz.secrets.SecretServiceConfig;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=SecretServiceConfig.class)
@Component(value="secretServiceConfig")
public class DefaultSecretServiceConfig
implements SecretServiceConfig {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretServiceConfig.class);
    private static final String PROP_MAX_LENGTH = "${secrets.value.max-length}";
    private static final String PROP_SECURED_PROPERTIES = "${secrets.secured-properties}";
    private static final int SECRET_VALUE_RANGE_MAX = 512000;
    private static final int SECRET_VALUE_RANGE_MIN = 1;
    private final int maxValueSize;
    private final Set<String> securedProperties;

    @Autowired
    public DefaultSecretServiceConfig(@Value(value="${secrets.value.max-length}") int maxValueSize, @Value(value="${secrets.secured-properties}") String securedPropertiesString) {
        Preconditions.checkArgument((maxValueSize >= 1 ? 1 : 0) != 0, (Object)"maxValueSize cannot be less than 1");
        Preconditions.checkArgument((maxValueSize <= 512000 ? 1 : 0) != 0, (Object)"maxValueSize cannot be greater than 512000");
        this.maxValueSize = maxValueSize;
        this.securedProperties = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)securedPropertiesString));
    }

    public int getMaxValueSize() {
        return this.maxValueSize;
    }

    public int getMinValueSize() {
        return 1;
    }

    @Nonnull
    public Set<String> getSecuredProperties() {
        return this.securedProperties;
    }

    public boolean isDisabled() {
        return SecretService.getState() == SecretServiceState.DISABLED;
    }

    @PostConstruct
    public void warnIfDisabled() {
        if (this.isDisabled()) {
            log.warn("Secret service is currently in disabled. This should only be used for troubleshooting purposes as Bitbucket secrets are not secured in this mode.");
        }
    }
}

