/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.auth.RememberMeMode;
import com.atlassian.bitbucket.dmz.policy.DmzPolicyService;
import com.atlassian.bitbucket.dmz.policy.RepositoryArchivePolicyChangedEvent;
import com.atlassian.bitbucket.dmz.policy.RepositoryDeletePolicyChangedEvent;
import com.atlassian.bitbucket.dmz.ratelimit.DefaultRateLimitSettingsModifiedEvent;
import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.secrets.DmzSecretService;
import com.atlassian.bitbucket.dmz.secrets.SecretNamespace;
import com.atlassian.bitbucket.dmz.secrets.SecretServiceConfig;
import com.atlassian.bitbucket.event.server.ApplicationSetupEvent;
import com.atlassian.bitbucket.event.server.BaseUrlChangedEvent;
import com.atlassian.bitbucket.event.server.DisplayNameChangedEvent;
import com.atlassian.bitbucket.event.server.HttpScmHostingChangedEvent;
import com.atlassian.bitbucket.event.server.MailHostConfigurationChangedEvent;
import com.atlassian.bitbucket.event.server.ServerEmailAddressChangedEvent;
import com.atlassian.bitbucket.event.server.ServerTimeZoneChangedEvent;
import com.atlassian.bitbucket.mail.MailAuthType;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.DatabaseType;
import com.atlassian.bitbucket.server.OperatingSystem;
import com.atlassian.bitbucket.util.CustomPreconditions;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.bitbucket.util.ValueWrapper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Validator;
import java.io.Serializable;
import java.net.URI;
import java.sql.Driver;
import java.sql.DriverManager;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(value=ApplicationPropertiesService.class)
@Component(value="applicationPropertiesService")
@DependsOn(value={"applicationSecretsUpgradeTaskRunner"})
public class ApplicationPropertiesServiceImpl
implements InternalApplicationPropertiesService,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPropertiesServiceImpl.class);
    private static final String PLUGIN_AUTHENTICATION_LEGACY_MODE_ENABLED_PROP = "atlassian.authentication.legacy.mode";
    private final BuildInfo buildInfo;
    private final Cache<ApplicationProperty.Key, ValueWrapper<String>> cache;
    private final DatabaseSupplier databaseSupplier;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final EventPublisher eventPublisher;
    private final ApplicationPropertyDao propertyDao;
    private final TransactionTemplate readTx;
    private final DmzSecretService secretService;
    private final SecretServiceConfig secretServiceConfig;
    private final TransactionSynchronizer transactionSynchronizer;
    private final Validator validator;
    private Environment environment;
    private volatile boolean setup;

    @Autowired
    public ApplicationPropertiesServiceImpl(BuildInfo buildInfo, CacheManager cacheManager, DataSourceConfiguration dataSourceConfiguration, EventPublisher eventPublisher, ApplicationPropertyDao propertyDao, PlatformTransactionManager transactionManager, TransactionSynchronizer transactionSynchronizer, Validator validator, DatabaseSupplier databaseSupplier, DmzSecretService secretService, SecretServiceConfig secretServiceConfig) {
        this.buildInfo = buildInfo;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.eventPublisher = eventPublisher;
        this.propertyDao = propertyDao;
        this.secretService = secretService;
        this.secretServiceConfig = secretServiceConfig;
        this.transactionSynchronizer = transactionSynchronizer;
        this.validator = validator;
        this.databaseSupplier = databaseSupplier;
        this.cache = this.createCache(cacheManager);
        this.readTx = new TransactionTemplate(transactionManager);
        this.readTx.setReadOnly(true);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void deleteMailHostConfiguration() {
        this.deleteOrUpdateMailHostConfiguration(null);
    }

    public String getAvatarSource() {
        return this.getApplicationProperty(ApplicationProperty.Key.AVATAR_SOURCE);
    }

    public URI getBaseUrl() {
        return UrlUtils.uncheckedCreateURI((String)this.getApplicationProperty(ApplicationProperty.Key.BASE_URL));
    }

    @Nonnull
    public String getBuildNumber() {
        return this.buildInfo.getBuildNumber();
    }

    @Nonnull
    public Date getBuildTimestamp() {
        return this.buildInfo.getBuildTimestamp();
    }

    @Nonnull
    public String getBuildVersion() {
        return this.buildInfo.getBuildVersion();
    }

    @Nullable
    public String getClusterId() {
        return this.getApplicationProperty(ApplicationProperty.Key.CLUSTER_ID);
    }

    @Nonnull
    public String getCommitHash() {
        return this.buildInfo.getCommitHash();
    }

    public String getCrowdEncryptionKeyPath() {
        return this.getApplicationProperty(ApplicationProperty.Key.CROWD_ENCRYPTION_KEY_PATH);
    }

    @Nonnull
    public DatabaseType getDatabaseType() {
        try {
            switch (this.databaseSupplier.get().getName()) {
                case "H2": {
                    return DatabaseType.H2;
                }
                case "Oracle": {
                    return DatabaseType.ORACLE;
                }
                case "PostgreSQL": {
                    return DatabaseType.POSTGRES;
                }
                case "Microsoft SQL Server": {
                    return DatabaseType.SQLSERVER;
                }
            }
            return DatabaseType.UNKNOWN;
        }
        catch (Exception e) {
            return DatabaseType.UNKNOWN;
        }
    }

    @Nonnull
    public String getDatabaseVersion() {
        return this.databaseSupplier.get().getVersion().toString();
    }

    public String getDefaultBranch() {
        return this.getApplicationProperty(ApplicationProperty.Key.DEFAULT_BRANCH);
    }

    @Nonnull
    @Transactional
    public TokenBucketSettings getDefaultRateLimitSettings() {
        return this.getPersistedDefaultRateLimitSettings().orElseGet(() -> {
            log.debug("Saving and returning recommended rate limit token bucket settings defaults (capacity={}, fillRate={})", (Object)60, (Object)5);
            TokenBucketSettings recommendedDefaultSettings = ApplicationPropertiesServiceImpl.getRecommendedDefaultRateLimitSettings();
            this.deleteOrUpdate(ApplicationProperty.Key.RATE_LIMITING_DEFAULT_CAPACITY, recommendedDefaultSettings.getCapacity());
            this.deleteOrUpdate(ApplicationProperty.Key.RATE_LIMITING_DEFAULT_FILL_RATE, recommendedDefaultSettings.getFillRate());
            return recommendedDefaultSettings;
        });
    }

    public String getDisplayName() {
        return this.getApplicationProperty(ApplicationProperty.Key.NAME);
    }

    @Nonnull
    public Optional<Long> getGracePeriodStartTime() {
        return Optional.ofNullable(this.getApplicationProperty(ApplicationProperty.Key.LICENSE_EXCEEDED_GRACE_PERIOD_START)).map(Long::valueOf);
    }

    @Nonnull
    public String getJdbcDriver() {
        return this.dataSourceConfiguration.getDriverClassName();
    }

    @Nonnull
    public String getJdbcDriverVersion() {
        String driverClassName = this.getJdbcDriver();
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver current = e.nextElement();
            if (!current.getClass().getName().equalsIgnoreCase(driverClassName)) continue;
            return String.format("%d.%d", current.getMajorVersion(), current.getMinorVersion());
        }
        return "Unknown";
    }

    @Nonnull
    public String getJdbcUrl() {
        return this.dataSourceConfiguration.getUrl();
    }

    @Nonnull
    public OptionalInt getLastLicensedUserCount() {
        try {
            return OptionalInt.of(Integer.parseInt(this.getApplicationProperty(ApplicationProperty.Key.LAST_LICENSED_USER_COUNT)));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    @Nonnull
    public Optional<ApplicationMode> getLastMode() {
        return ApplicationMode.fromId((String)this.getApplicationProperty(ApplicationProperty.Key.MODE));
    }

    public OperatingSystem getLastOperatingSystem() {
        String value = this.getApplicationProperty(ApplicationProperty.Key.LAST_OS);
        return value == null ? null : OperatingSystem.valueOf((String)value);
    }

    public String getLastSharedHomeDir() {
        return this.getApplicationProperty(ApplicationProperty.Key.LAST_HOME);
    }

    @Nonnull
    public Locale getLocale() {
        String locale = this.getApplicationProperty(ApplicationProperty.Key.LOCALE);
        return locale != null ? LocaleUtils.toLocale((String)locale) : Locale.getDefault();
    }

    @Nonnull
    public URI getLoginUri(URI redirectUri) {
        String loginUri = String.valueOf(this.getBaseUrl()) + "/login?next=" + UrlUtils.encodeURL((String)redirectUri.toString());
        return UrlUtils.uncheckedCreateURI((String)loginUri);
    }

    public MailHostConfiguration getMailHostConfiguration() {
        String oauthProviderId = this.getApplicationProperty(ApplicationProperty.Key.MAIL_OAUTH_PROVIDER_ID);
        MailHostConfiguration config = new MailHostConfiguration.Builder().hostname(this.getApplicationProperty(ApplicationProperty.Key.MAIL_HOST)).port(NumberUtils.parse((String)this.getApplicationProperty(ApplicationProperty.Key.MAIL_HOST_PORT), (String)"Configured mail host port is not a number. Using default!")).protocol(MailProtocol.fromString((String)this.getApplicationProperty(ApplicationProperty.Key.MAIL_PROTOCOL))).authType(oauthProviderId == null ? MailAuthType.BASIC : MailAuthType.OAUTH2).oauth2ProviderId(oauthProviderId).tokenId(this.getApplicationProperty(ApplicationProperty.Key.MAIL_OAUTH_TOKEN_ID)).useStartTls(Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.MAIL_USE_TLS))).requireStartTls(Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.MAIL_REQUIRE_TLS))).username(this.getApplicationProperty(ApplicationProperty.Key.MAIL_HOST_USERNAME)).password(this.getApplicationProperty(ApplicationProperty.Key.MAIL_HOST_PASSWORD)).build();
        return config.getHostname() == null && config.getPort() == null && config.getUsername() == null ? null : config;
    }

    public int getMaxCaptchaAttempts() {
        return NumberUtils.parse((String)this.getApplicationProperty(ApplicationProperty.Key.MAX_CAPTCHA_ATTEMPTS), (Integer)5, (String)"Configured max captcha attempts is not a number. Using default!");
    }

    @Nonnull
    public ApplicationMode getMode() {
        return ApplicationMode.fromId((String)this.environment.getProperty("application.mode")).orElse(ApplicationMode.DEFAULT);
    }

    public String getPluginProperty(@Nonnull String propertyName) {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName);
    }

    public String getPluginProperty(@Nonnull String propertyName, String defaultValue) {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public int getPluginProperty(@Nonnull String propertyName, int defaultValue) throws NumberFormatException {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public long getPluginProperty(@Nonnull String propertyName, long defaultValue) throws NumberFormatException {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public boolean getPluginProperty(@Nonnull String propertyName, boolean defaultValue) {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public double getPluginProperty(@Nonnull String propertyName, double defaultValue) {
        this.validatePluginPropertyName(propertyName);
        return this.getProperty(propertyName, defaultValue);
    }

    public String getProperty(@Nonnull String propertyName) {
        return this.environment.getProperty(propertyName);
    }

    public String getProperty(@Nonnull String propertyName, String defaultValue) {
        return this.environment.getProperty(propertyName, defaultValue);
    }

    public int getProperty(@Nonnull String propertyName, int defaultValue) throws NumberFormatException {
        String value = this.environment.getProperty(propertyName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public long getProperty(@Nonnull String propertyName, long defaultValue) throws NumberFormatException {
        String value = this.environment.getProperty(propertyName);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public double getProperty(@Nonnull String propertyName, double defaultValue) throws NumberFormatException {
        String value = this.environment.getProperty(propertyName);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public boolean getProperty(@Nonnull String propertyName, boolean defaultValue) {
        String value = this.environment.getProperty(propertyName);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    @Nonnull
    public RememberMeMode getRememberMeMode() {
        return RememberMeMode.fromId((String)this.getProperty("auth.remember-me.enabled", RememberMeMode.OPTIONAL.getId()));
    }

    public Permission getRepositoryArchivePolicy() {
        String value = this.getApplicationProperty(ApplicationProperty.Key.REPOSITORY_ARCHIVE_POLICY);
        return value == null ? DmzPolicyService.DEFAULT_REPOSITORY_ARCHIVE_POLICY : Permission.valueOf((String)value);
    }

    public Permission getRepositoryDeletePolicy() {
        String value = this.getApplicationProperty(ApplicationProperty.Key.REPOSITORY_DELETE_POLICY);
        return value == null ? DmzPolicyService.DEFAULT_REPOSITORY_DELETE_POLICY : Permission.valueOf((String)value);
    }

    public String getServerEmailAddress() {
        return this.getApplicationProperty(ApplicationProperty.Key.EMAIL_ADDRESS);
    }

    public String getServerId() {
        return this.getApplicationProperty(ApplicationProperty.Key.SERVER_ID);
    }

    @Nonnull
    public Optional<ZoneId> getServerTimeZone() {
        String applicationProperty = this.getApplicationProperty(ApplicationProperty.Key.SERVER_TIMEZONE);
        try {
            return Optional.ofNullable(applicationProperty).map(ZoneId::of);
        }
        catch (DateTimeException e) {
            log.debug("Unable to find timezone {}. Assuming no server timezone.", (Object)applicationProperty);
            return Optional.empty();
        }
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public Optional<String> getSystemSignedGitObjectsSecretPassphrase() {
        return Optional.ofNullable(this.getApplicationProperty(ApplicationProperty.Key.SYSTEM_SIGNED_GIT_OBJECTS_SECRET_PASSPHRASE));
    }

    public boolean isAllowPublicSignUp() {
        return Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.ALLOW_PUBLIC_SIGNUP));
    }

    public boolean isAuthenticationLegacyModeEnabled() {
        return this.getProperty(PLUGIN_AUTHENTICATION_LEGACY_MODE_ENABLED_PROP, true);
    }

    public boolean isBootstrapped() {
        return this.propertyDao.isSetup();
    }

    public boolean isCrowdEncryptionUpgradeCompleted() {
        return Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.CROWD_ENCRYPTION_UPGRADE_COMPLETED));
    }

    public boolean isDebugLoggingEnabled() {
        String property = this.getApplicationPropertyOrFallback(ApplicationProperty.Key.DEBUG_LOGGING_ENABLED, "logging.debug.enabled");
        return Boolean.parseBoolean(property);
    }

    public boolean isDisasterRecovery() {
        return this.getProperty("disaster.recovery", false);
    }

    public boolean isHttpScmHostingEnabled() {
        String property = this.getApplicationProperty(ApplicationProperty.Key.HTTP_SCM_HOSTING_ENABLED);
        return property == null || Boolean.parseBoolean(property);
    }

    public boolean isJmxEnabled() {
        return this.getProperty("jmx.enabled", true);
    }

    public boolean isMeshRepositoryCreationEnabled() {
        return Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.MESH_REPOSITORY_CREATION));
    }

    public boolean isSecretScanningEnabledForPrivateRepositories() {
        return Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.SECRET_SCAN_ON_PRIVATE_REPOSITORIES));
    }

    public boolean isProfilingEnabled() {
        String property = this.getApplicationPropertyOrFallback(ApplicationProperty.Key.PROFILING_ENABLED, "logging.profiling.enabled");
        return Boolean.parseBoolean(property);
    }

    public boolean isRateLimitEnabled() {
        String enabled = this.getApplicationProperty(ApplicationProperty.Key.RATE_LIMITING_ENABLED);
        return enabled == null ? false : Boolean.parseBoolean(enabled);
    }

    public boolean isSetup() {
        if (!this.setup) {
            this.setup = Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.SETUP_COMPLETED));
        }
        return this.setup;
    }

    public boolean isShowCaptchaOnSignUp() {
        return Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.REQUIRE_CAPTCHA_ON_SIGNUP));
    }

    public boolean isSystemSignedGitObjectsEnabled() {
        return Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.SYSTEM_SIGNED_GIT_OBJECTS_ENABLED));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setAllowPublicSignUp(boolean publicSignUp) {
        this.updateApplicationProperty(ApplicationProperty.Key.ALLOW_PUBLIC_SIGNUP, Boolean.toString(publicSignUp));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setAvatarSource(String avatarSource) {
        this.updateApplicationProperty(ApplicationProperty.Key.AVATAR_SOURCE, avatarSource);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setBaseURL(@Nonnull URI baseUri) {
        Objects.requireNonNull(baseUri, "baseUri");
        String baseUrl = StringUtils.removeEnd((String)baseUri.toString(), (String)"/");
        String oldValue = this.updateApplicationProperty(ApplicationProperty.Key.BASE_URL, baseUrl);
        if (ObjectUtils.notEqual((Object)baseUrl, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new BaseUrlChangedEvent((Object)this, oldValue, baseUrl));
        }
    }

    @Transactional
    @Unsecured(value="Internal use only")
    public void setClusterId(@Nonnull String clusterId) {
        this.updateApplicationProperty(ApplicationProperty.Key.CLUSTER_ID, Objects.requireNonNull(clusterId, "clusterId"));
    }

    @Unsecured(value="Internal use only")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void setCrowdEncryptionKeyPath(@Nullable String encryptionKeyPath) {
        this.deleteOrUpdate(ApplicationProperty.Key.CROWD_ENCRYPTION_KEY_PATH, encryptionKeyPath);
    }

    @Unsecured(value="Internal use only")
    @Transactional
    public void setCrowdEncryptionUpgradeCompleted() {
        this.deleteOrUpdate(ApplicationProperty.Key.CROWD_ENCRYPTION_UPGRADE_COMPLETED, true);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setDebugLoggingEnabled(boolean debugLoggingEnabled) {
        this.updateApplicationProperty(ApplicationProperty.Key.DEBUG_LOGGING_ENABLED, Boolean.toString(debugLoggingEnabled));
    }

    @Transactional
    public void setDefaultBranch(String defaultBranch) {
        this.deleteOrUpdate(ApplicationProperty.Key.DEFAULT_BRANCH, defaultBranch);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public boolean setDefaultRateLimitSettings(@Nonnull TokenBucketSettings settings) {
        Objects.requireNonNull(settings, "settings");
        Optional<TokenBucketSettings> oldSettings = this.getPersistedDefaultRateLimitSettings();
        if (oldSettings.isPresent() && Objects.equals(settings, oldSettings.get())) {
            log.debug("Settings have not changed, skipping update (capacity={}, fillRate={})", (Object)settings.getCapacity(), (Object)settings.getFillRate());
            return false;
        }
        this.deleteOrUpdate(ApplicationProperty.Key.RATE_LIMITING_DEFAULT_CAPACITY, settings.getCapacity());
        this.deleteOrUpdate(ApplicationProperty.Key.RATE_LIMITING_DEFAULT_FILL_RATE, settings.getFillRate());
        log.debug("Default rate limit settings updated: capacity={}, fillRate={}", (Object)settings.getCapacity(), (Object)settings.getFillRate());
        this.eventPublisher.publish((Object)new DefaultRateLimitSettingsModifiedEvent(settings, oldSettings.orElse(ApplicationPropertiesServiceImpl.getRecommendedDefaultRateLimitSettings()), (Object)this));
        return true;
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setDisplayName(@Nonnull String displayName) {
        CustomPreconditions.checkRequiredString((String)displayName, (int)255);
        String oldValue = this.updateApplicationProperty(ApplicationProperty.Key.NAME, displayName);
        if (ObjectUtils.notEqual((Object)displayName, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new DisplayNameChangedEvent((Object)this, oldValue, displayName));
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Transactional
    public void setGracePeriodStartTime(@Nullable Long time) {
        this.deleteOrUpdate(ApplicationProperty.Key.LICENSE_EXCEEDED_GRACE_PERIOD_START, time);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setHttpScmHostingEnabled(boolean enabled) {
        boolean wasEnabled;
        String oldValue = this.deleteOrUpdate(ApplicationProperty.Key.HTTP_SCM_HOSTING_ENABLED, enabled ? null : "false");
        boolean bl = wasEnabled = oldValue == null || Boolean.parseBoolean(oldValue);
        if (wasEnabled != enabled) {
            this.eventPublisher.publish((Object)new HttpScmHostingChangedEvent((Object)this, Boolean.valueOf(wasEnabled), Boolean.valueOf(enabled)));
        }
    }

    @Transactional
    public void setLastLicensedUserCount(int lastLicensedUserCount) {
        this.deleteOrUpdate(ApplicationProperty.Key.LAST_LICENSED_USER_COUNT, lastLicensedUserCount);
    }

    public void setLastOperatingSystem(@Nonnull OperatingSystem operatingSystem) {
        Objects.requireNonNull(operatingSystem, "operatingSystem");
        this.updateApplicationProperty(ApplicationProperty.Key.LAST_OS, operatingSystem.name());
    }

    @Transactional
    public void setLastSharedHomeDir(@Nonnull String lastSharedHomeDir) {
        Preconditions.checkArgument((!Objects.requireNonNull(lastSharedHomeDir, "lastSharedHomeDir").trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank path is required");
        this.updateApplicationProperty(ApplicationProperty.Key.LAST_HOME, lastSharedHomeDir);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setLocale(Locale locale) {
        this.deleteOrUpdate(ApplicationProperty.Key.LOCALE, locale != null ? locale.toString() : null);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setMailHostConfiguration(@Nonnull MailHostConfiguration mailHostConfiguration) {
        this.deleteOrUpdateMailHostConfiguration(Objects.requireNonNull(mailHostConfiguration, "mailHostConfiguration"));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setMaxCaptchaAttempts(int maxCaptchaAttempts) {
        this.updateApplicationProperty(ApplicationProperty.Key.MAX_CAPTCHA_ATTEMPTS, Integer.toString(maxCaptchaAttempts));
    }

    @Transactional
    public void setMode(@Nonnull ApplicationMode mode) {
        this.updateApplicationProperty(ApplicationProperty.Key.MODE, Objects.requireNonNull(mode, "mode").getId());
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setMeshRepositoryCreationEnabled(boolean createOnMesh) {
        this.updateApplicationProperty(ApplicationProperty.Key.MESH_REPOSITORY_CREATION, Boolean.toString(createOnMesh));
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setProfilingEnabled(boolean profilingEnabled) {
        this.updateApplicationProperty(ApplicationProperty.Key.PROFILING_ENABLED, Boolean.toString(profilingEnabled));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setRateLimitEnabled(boolean enabled) {
        this.updateApplicationProperty(ApplicationProperty.Key.RATE_LIMITING_ENABLED, Boolean.toString(enabled));
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setRepositoryArchivePolicy(@Nonnull Permission permission) {
        Objects.requireNonNull(permission, "permission");
        String oldValue = this.updateApplicationProperty(ApplicationProperty.Key.REPOSITORY_ARCHIVE_POLICY, permission.name());
        Permission oldPermission = DmzPolicyService.DEFAULT_REPOSITORY_ARCHIVE_POLICY;
        if (oldValue != null) {
            oldPermission = Permission.valueOf((String)oldValue);
        }
        this.eventPublisher.publish((Object)new RepositoryArchivePolicyChangedEvent((Object)this, oldPermission, permission));
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setRepositoryDeletePolicy(@Nonnull Permission permission) {
        Objects.requireNonNull(permission, "permission");
        String oldValue = this.updateApplicationProperty(ApplicationProperty.Key.REPOSITORY_DELETE_POLICY, permission.name());
        Permission oldPermission = DmzPolicyService.DEFAULT_REPOSITORY_DELETE_POLICY;
        if (oldValue != null) {
            oldPermission = Permission.valueOf((String)oldValue);
        }
        this.eventPublisher.publish((Object)new RepositoryDeletePolicyChangedEvent((Object)this, oldPermission, permission));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setSecretScanningEnabledForPrivateRepositories(boolean enabled) {
        this.updateApplicationProperty(ApplicationProperty.Key.SECRET_SCAN_ON_PRIVATE_REPOSITORIES, Boolean.toString(enabled));
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setServerEmailAddress(String emailAddress) {
        Preconditions.checkArgument((boolean)new EmailValidator().isValid((CharSequence)emailAddress, null), (Object)"email address must be valid");
        String oldValue = this.deleteOrUpdate(ApplicationProperty.Key.EMAIL_ADDRESS, emailAddress);
        if (ObjectUtils.notEqual((Object)emailAddress, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new ServerEmailAddressChangedEvent((Object)this, oldValue, emailAddress));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setServerId(String serverId) {
        this.updateApplicationProperty(ApplicationProperty.Key.SERVER_ID, serverId);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setServerTimeZone(@Nullable ZoneId zone) {
        String oldValue = this.deleteOrUpdate(ApplicationProperty.Key.SERVER_TIMEZONE, zone);
        if (ObjectUtils.notEqual((Object)zone, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new ServerTimeZoneChangedEvent((Object)this, oldValue, zone == null ? null : zone.getId()));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setSetup(boolean setup) {
        boolean oldValue = this.isSetup();
        if (oldValue != setup) {
            this.updateApplicationProperty(ApplicationProperty.Key.SETUP_COMPLETED, Boolean.toString(setup));
            this.eventPublisher.publish((Object)new ApplicationSetupEvent((Object)this, Boolean.valueOf(oldValue), Boolean.valueOf(setup)));
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setShowCaptchaOnSignUp(boolean captchaOnSignUp) {
        this.updateApplicationProperty(ApplicationProperty.Key.REQUIRE_CAPTCHA_ON_SIGNUP, Boolean.toString(captchaOnSignUp));
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setSystemSignedGitObjectsEnabled(boolean enabled) {
        this.updateApplicationProperty(ApplicationProperty.Key.SYSTEM_SIGNED_GIT_OBJECTS_ENABLED, Boolean.toString(enabled));
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setSystemSignedGitObjectsSecretPassphrase(@Nonnull String passphrase) {
        Objects.requireNonNull(passphrase, "passphrase");
        this.updateApplicationProperty(ApplicationProperty.Key.SYSTEM_SIGNED_GIT_OBJECTS_SECRET_PASSPHRASE, passphrase);
    }

    private static TokenBucketSettings getRecommendedDefaultRateLimitSettings() {
        return new TokenBucketSettings.Builder().capacity(60).fillRate(5).build();
    }

    private Cache<ApplicationProperty.Key, ValueWrapper<String>> createCache(CacheManager cacheManager) {
        CacheLoader<ApplicationProperty.Key, ValueWrapper<String>> cacheLoader = new CacheLoader<ApplicationProperty.Key, ValueWrapper<String>>(){

            @Nonnull
            public ValueWrapper<String> load(@Nonnull ApplicationProperty.Key key) {
                return ApplicationPropertiesServiceImpl.this.wrap(ApplicationPropertiesServiceImpl.this.rawGetApplicationProperty(key));
            }
        };
        CacheSettings cacheSettings = new CacheSettingsBuilder().maxEntries(Integer.MAX_VALUE).replicateAsynchronously().replicateViaInvalidation().build();
        return cacheManager.getCache(ApplicationPropertiesService.class.getName(), (CacheLoader)cacheLoader, cacheSettings);
    }

    private void delete(ApplicationProperty.Key ... keys) {
        for (ApplicationProperty.Key key : keys) {
            this.deleteOrUpdate(key, null);
        }
    }

    private String deleteOrUpdate(ApplicationProperty.Key key, Object newValue) {
        String newValueString = Objects.toString(newValue, null);
        if (key.isSecret() && !this.secretServiceConfig.isDisabled()) {
            return this.deleteOrUpdateSecretProperty(key, newValueString);
        }
        return this.deleteOrUpdateRegularProperty(key, newValueString);
    }

    private String deleteOrUpdateRegularProperty(final ApplicationProperty.Key key, final String newValue) {
        final String oldValue = this.unwrap((ValueWrapper<String>)((ValueWrapper)this.cache.get((Object)key)));
        if (newValue == null) {
            if (oldValue != null) {
                this.propertyDao.deleteById(key);
            }
        } else {
            ApplicationProperty newProperty = new ApplicationProperty(key, newValue);
            if (oldValue == null) {
                this.propertyDao.create(newProperty);
            } else {
                this.propertyDao.update(newProperty);
            }
        }
        this.transactionSynchronizer.register(new TransactionSynchronization(){

            public void afterCommit() {
                if (!ApplicationPropertiesServiceImpl.this.cache.replace((Object)key, ApplicationPropertiesServiceImpl.this.wrap(oldValue), ApplicationPropertiesServiceImpl.this.wrap(newValue))) {
                    ApplicationPropertiesServiceImpl.this.cache.remove((Object)key);
                }
            }
        });
        return oldValue;
    }

    private String deleteOrUpdateSecretProperty(ApplicationProperty.Key key, String newValue) {
        String oldSecretValue = this.safeGetSecret(key);
        if (newValue == null) {
            this.secretService.delete(SecretNamespace.INTERNAL, key.getId());
            this.propertyDao.deleteById(key);
        } else {
            this.secretService.put(SecretNamespace.INTERNAL, key.getId(), newValue);
            ApplicationProperty securedMarker = new ApplicationProperty(key, "{ATL_SECURED}");
            if (this.propertyDao.getById(key) == null) {
                this.propertyDao.create(securedMarker);
            } else {
                this.propertyDao.update(securedMarker);
            }
        }
        return oldSecretValue;
    }

    private void deleteOrUpdateMailHostConfiguration(MailHostConfiguration mailHostConfiguration) {
        MailHostConfiguration oldValue = this.getMailHostConfiguration();
        if (mailHostConfiguration == null) {
            this.delete(ApplicationProperty.Key.MAIL_HOST, ApplicationProperty.Key.MAIL_HOST_PORT, ApplicationProperty.Key.MAIL_HOST_USERNAME, ApplicationProperty.Key.MAIL_HOST_PASSWORD, ApplicationProperty.Key.MAIL_PROTOCOL, ApplicationProperty.Key.MAIL_USE_TLS, ApplicationProperty.Key.MAIL_REQUIRE_TLS, ApplicationProperty.Key.MAIL_OAUTH_PROVIDER_ID, ApplicationProperty.Key.MAIL_OAUTH_TOKEN_ID);
        } else {
            ValidationUtils.validate((Validator)this.validator, (Object)mailHostConfiguration, (Class[])new Class[0]);
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST, mailHostConfiguration.getHostname());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_PORT, mailHostConfiguration.getPort());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_USERNAME, mailHostConfiguration.getUsername());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_PASSWORD, mailHostConfiguration.getPassword());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_PROTOCOL, mailHostConfiguration.getProtocol().name());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_USE_TLS, mailHostConfiguration.isUseStartTls());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_REQUIRE_TLS, mailHostConfiguration.isRequireStartTls());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_OAUTH_PROVIDER_ID, mailHostConfiguration.getAuthType() == MailAuthType.OAUTH2 ? mailHostConfiguration.getOauth2ProviderId() : null);
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_OAUTH_TOKEN_ID, mailHostConfiguration.getAuthType() == MailAuthType.OAUTH2 ? mailHostConfiguration.getTokenId() : null);
        }
        if (ObjectUtils.notEqual((Object)mailHostConfiguration, (Object)oldValue)) {
            this.eventPublisher.publish((Object)new MailHostConfigurationChangedEvent((Object)this, oldValue, mailHostConfiguration));
        }
    }

    private String getApplicationProperty(ApplicationProperty.Key key) {
        try {
            String maybeValue = this.unwrap((ValueWrapper<String>)((ValueWrapper)this.cache.get((Object)key)));
            if (maybeValue != null && !"{ATL_SECURED}".equals(maybeValue)) {
                return maybeValue;
            }
        }
        catch (CacheException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e);
        }
        if (key.isSecret() && !this.secretServiceConfig.isDisabled()) {
            return this.safeGetSecret(key);
        }
        return null;
    }

    private String getApplicationPropertyOrFallback(ApplicationProperty.Key key, String propertyName) {
        String property = this.getApplicationProperty(key);
        return property == null ? this.getProperty(propertyName) : property;
    }

    private Optional<TokenBucketSettings> getPersistedDefaultRateLimitSettings() {
        String capacity = this.getApplicationProperty(ApplicationProperty.Key.RATE_LIMITING_DEFAULT_CAPACITY);
        String fillRate = this.getApplicationProperty(ApplicationProperty.Key.RATE_LIMITING_DEFAULT_FILL_RATE);
        if (capacity == null || fillRate == null) {
            log.debug("Default rate limit token bucket settings are not set.");
            return Optional.empty();
        }
        try {
            return Optional.of(new TokenBucketSettings.Builder().capacity(Integer.parseInt(capacity)).fillRate(Integer.parseInt(fillRate)).build());
        }
        catch (IllegalArgumentException e) {
            log.warn("Persisted default rate limit settings are invalid (capacity={}, fillRate={}).", (Object)capacity, (Object)fillRate);
            return Optional.empty();
        }
    }

    private String rawGetApplicationProperty(ApplicationProperty.Key key) {
        ApplicationProperty property = (ApplicationProperty)this.readTx.execute(status -> this.propertyDao.getById(key));
        return property == null ? null : property.getValue();
    }

    private String safeGetSecret(ApplicationProperty.Key key) {
        try {
            return this.secretService.get(SecretNamespace.INTERNAL, key.getId()).orElse(null);
        }
        catch (SecretServiceException e) {
            log.error("Failed to get property {} from secure storage", (Object)key, (Object)e);
            return null;
        }
    }

    private String unwrap(ValueWrapper<String> wrapper) {
        return wrapper == null ? null : (String)((Object)wrapper.get());
    }

    private String updateApplicationProperty(ApplicationProperty.Key key, @Nonnull String newValue) {
        return this.deleteOrUpdate(key, Objects.requireNonNull(newValue, "newValue"));
    }

    private void validatePluginPropertyName(String propertyName) {
        Objects.requireNonNull(propertyName, "Property name must not be null");
        Preconditions.checkArgument((boolean)propertyName.startsWith("plugin."), (Object)("Property name \"" + propertyName + "\" does not start with \"plugin.\""));
    }

    private ValueWrapper<String> wrap(String value) {
        return new ValueWrapper((Serializable)((Object)value));
    }
}

