/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.stash.internal.server.DataStoreListener;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class DataStoreListenerRegistry
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DataStoreListenerRegistry.class);
    private final I18nService i18nService;
    private final List<DataStoreListener> listeners;

    public DataStoreListenerRegistry(I18nService i18nService) {
        this.i18nService = i18nService;
        this.listeners = new ArrayList<DataStoreListener>();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataStoreListener) {
            this.listeners.add((DataStoreListener)bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public SimpleCancelState raiseOnAttach(DataStore dataStore) {
        SimpleCancelState cancelState = new SimpleCancelState();
        for (DataStoreListener listener : this.listeners) {
            try {
                listener.onAttach(dataStore, (CancelState)cancelState);
            }
            catch (RuntimeException e) {
                log.error("{} threw an exception during onAttach", (Object)listener.getClass().getName(), (Object)e);
                cancelState.cancel(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.attachcanceled", new Object[0]));
            }
            if (!cancelState.isCanceled()) continue;
            break;
        }
        return cancelState;
    }

    public void raiseOnAttached(DataStore dataStore) {
        for (DataStoreListener listener : this.listeners) {
            try {
                listener.onAttached(dataStore);
            }
            catch (RuntimeException e) {
                log.error("{} threw an exception during onAttached", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }
}

