/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.server.InvalidDataStoreException;
import com.atlassian.bitbucket.dmz.server.MinimalDataStore;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.internal.server.DataStoreLayout;
import com.atlassian.stash.internal.server.MinimalDataStoreDao;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreValidator {
    private static final Logger log = LoggerFactory.getLogger(DataStoreValidator.class);
    private final EventPublisher eventPublisher;
    private final MinimalDataStoreDao minimalDataStoreDao;
    private final Set<String> validatedPaths;

    public DataStoreValidator(EventPublisher eventPublisher, MinimalDataStoreDao minimalDataStoreDao) {
        this.eventPublisher = eventPublisher;
        this.minimalDataStoreDao = minimalDataStoreDao;
        this.validatedPaths = Sets.newConcurrentHashSet();
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent event) {
        try {
            if (event.isMaybeNetworkPartitionResolved()) {
                this.validateAll();
            }
        }
        catch (InvalidDataStoreException e) {
            Event johnsonEvent = new Event(EventType.get((String)"invalid-data-store"), e.getMessage(), EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
    }

    public void validateAll() {
        List stores = this.minimalDataStoreDao.listAll();
        for (MinimalDataStore store : stores) {
            this.validate(store);
        }
    }

    private void validate(MinimalDataStore store) {
        if (this.validatedPaths.contains(store.getPath())) {
            return;
        }
        Path dir = store.getDir();
        String uuid = store.getUuid();
        try {
            if (this.verifyRealPath(dir) && this.verifyPropertiesFile(dir, uuid)) {
                this.validatedPaths.add(store.getPath());
                return;
            }
        }
        catch (AccessDeniedException e) {
            log.error("{} cannot be accessed", (Object)dir, (Object)e);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.error("{} does not exist", (Object)dir, (Object)e);
        }
        catch (Exception e) {
            log.error("{} could not be validated", (Object)dir, (Object)e);
        }
        String message = "One or more data stores is incorrectly mounted. Check the logs for additional details.";
        throw new InvalidDataStoreException(new KeyedMessage("bitbucket.storage.datastore.cluster.validationfailed", message, message));
    }

    private boolean verifyPropertiesFile(Path dir, String uuid) throws IOException {
        try {
            Properties properties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(dir.resolve("store.properties"), StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            String storeUuid = properties.getProperty("store.uuid");
            String storeVersion = properties.getProperty("store.version");
            if (!uuid.equals(storeUuid)) {
                log.error("{} The data store's UUID [{}] does not match (Expected: {})", new Object[]{dir, storeUuid, uuid});
                return false;
            }
            if (storeVersion == null) {
                log.error("{} The data store does not define a version; \"{}\" is invalid", (Object)dir, (Object)"store.properties");
                return false;
            }
            Version version = new Version(storeVersion);
            if (DataStoreLayout.VERSION.getMajor() < version.getMajor()) {
                log.error("{} The data store's version [{}] is not supported (Required: {}.x)", new Object[]{dir, storeVersion, DataStoreLayout.VERSION.getMajor()});
                return false;
            }
            if (version.getMajor() == 0) {
                log.error("{} The data store's version [{}] is invalid", (Object)dir, (Object)storeVersion);
                return false;
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.error("{} does not exist. The data store may not be mounted correctly.", (Object)dir.resolve("store.properties"));
            return false;
        }
        return true;
    }

    private boolean verifyRealPath(Path dir) throws IOException {
        Path realPath = dir.toRealPath(new LinkOption[0]);
        if (dir.toString().equals(realPath.toString())) {
            return true;
        }
        log.error("The path {} does not match the directory's real path ({})", (Object)dir, (Object)realPath);
        return false;
    }
}

