/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.server.AttachDataStoreRequest;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DataStoreConfig;
import com.atlassian.bitbucket.dmz.server.DataStoreType;
import com.atlassian.bitbucket.dmz.server.DmzDataStoreService;
import com.atlassian.bitbucket.dmz.server.InvalidDataStoreException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.SimpleCancelState;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MemberSelector;
import com.atlassian.nutcluster.core.MultiExecutionCallback;
import com.atlassian.nutcluster.instance.EndpointQualifier;
import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.cluster.NutclusterClusterNode;
import com.atlassian.stash.internal.server.AttachDataStoreDisabledException;
import com.atlassian.stash.internal.server.DataStoreAlreadyExistsException;
import com.atlassian.stash.internal.server.DataStoreDao;
import com.atlassian.stash.internal.server.DataStoreLayout;
import com.atlassian.stash.internal.server.DataStoreListenerRegistry;
import com.atlassian.stash.internal.server.DataStoreSymbolicLinkDirectoryException;
import com.atlassian.stash.internal.server.InternalDataStore;
import com.atlassian.stash.internal.server.InternalDataStoreService;
import com.atlassian.stash.internal.server.SimpleDataStoreConfig;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;

@AvailableToPlugins(value=DmzDataStoreService.class)
@Service(value="dataStoreService")
public class DefaultDataStoreService
implements InternalDataStoreService {
    static final String UUID_SHARED_HOME = "shared";
    static final String UUID_VALIDATED = "validated";
    private static final Logger log = LoggerFactory.getLogger(DefaultDataStoreService.class);
    private final ClusterService clusterService;
    private final IExecutorService executorService;
    private final HomeLayout homeLayout;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final DataStoreListenerRegistry listenerRegistry;
    private final LockService lockService;
    private final DataStoreDao storeDao;
    private final TransactionSynchronizer synchronizer;
    private final SecureTokenGenerator tokenGenerator;
    @Value(value="${storage.datastore.validation.timeout:60}")
    private long validationTimeout = 60L;

    @Autowired
    public DefaultDataStoreService(ClusterService clusterService, IExecutorService executorService, HomeLayout homeLayout, I18nService i18nService, LicenseService licenseService, DataStoreListenerRegistry listenerRegistry, LockService lockService, DataStoreDao storeDao, TransactionSynchronizer synchronizer, SecureTokenGenerator tokenGenerator) {
        this.clusterService = clusterService;
        this.executorService = executorService;
        this.homeLayout = homeLayout;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.listenerRegistry = listenerRegistry;
        this.lockService = lockService;
        this.storeDao = storeDao;
        this.synchronizer = synchronizer;
        this.tokenGenerator = tokenGenerator;
    }

    @Nonnull
    @Transactional(propagation=Propagation.MANDATORY)
    @Unsecured(value="This internal API is only called as part of creating a repository, after appropriate permission checks")
    public Optional<InternalDataStore> assignForHierarchy(@Nonnull String hierarchyId) {
        if (Objects.requireNonNull(hierarchyId, "hierarchyId").trim().length() < 4) {
            throw new IllegalArgumentException("The provided hierarchy ID, [" + hierarchyId + "], is too short.");
        }
        InternalDataStore store = this.chooseStoreByUsableSpace();
        if (store == null) {
            return Optional.empty();
        }
        Path hierarchyDir = DataStoreLayout.getHierarchyDir((DataStore)store, (String)hierarchyId);
        Path hierarchyParentDir = hierarchyDir.getParent();
        if (!Files.isDirectory(hierarchyParentDir, new LinkOption[0])) {
            String lockName = "bitbucket:dataStore:createHierarchy:" + String.valueOf(hierarchyParentDir.getFileName());
            try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(lockName));){
                MoreFiles.mkdir((Path)hierarchyParentDir);
            }
        }
        MoreFiles.mkdir((Path)hierarchyDir);
        return Optional.of(store);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public InternalDataStore attach(@Nonnull AttachDataStoreRequest request) {
        InternalDataStore dataStore;
        SimpleCancelState cancelState;
        Objects.requireNonNull(request, "request");
        BitbucketServerLicense license = this.licenseService.get();
        if (license == null || !license.isClusteringEnabled()) {
            log.warn("{} could not be attached; {}", (Object)request.getPath(), (Object)(license == null ? "no license is installed" : "a Data Center license is not installed"));
            throw new AttachDataStoreDisabledException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.attachdisabled", new Object[0]));
        }
        this.storeDao.findByPath(request.getPath()).ifPresent(store -> {
            log.warn("{} has already been attached (UUID: {})", (Object)store.getPath(), (Object)store.getUuid());
            throw new DataStoreAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.alreadyattached", new Object[]{store.getPath()}));
        });
        Path path = Paths.get(request.getPath(), new String[0]);
        try {
            this.verifyDirectory(path);
            this.verifyRealPath(path);
            this.verifyNotNested(path);
        }
        catch (AccessDeniedException e) {
            log.error("Could not access {}; it cannot be used as a data store", (Object)path, (Object)e);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.accessdenied", new Object[]{Product.NAME, path}), (Throwable)e);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.error("{} does not exist; it cannot be used as a data store", (Object)path, (Object)e);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.notfound", new Object[]{path, Product.NAME}), (Throwable)e);
        }
        catch (IOException e) {
            log.error("Validation failed for {}; it cannot be used a data store", (Object)path, (Object)e);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.validationfailed", new Object[]{Product.NAME, path}), (Throwable)e);
        }
        if (request.isDryRun()) {
            return new InternalDataStore.Builder(path).uuid(UUID_VALIDATED).build();
        }
        try {
            DataStoreLayout.create((Path)path);
        }
        catch (DataStoreSymbolicLinkDirectoryException e) {
            log.error("Could not create subdirectory at {}, as subdirectory already exists and is a symbolic link", (Object)e.getDirectoryPath());
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.invalidtype.subdirectory.symlink", new Object[]{path}), (Throwable)e);
        }
        catch (IOException e) {
            log.error("Cannot write to {}; check your filesystem permissions and try again", (Object)path, (Object)e);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.notwritable", new Object[]{Product.NAME, path}), (Throwable)e);
        }
        String uuid = this.tokenGenerator.generateToken().toLowerCase(Locale.ROOT);
        if (uuid.length() > 40) {
            uuid = uuid.substring(0, 40);
        }
        Path storeProperties = path.resolve("store.properties");
        try {
            Files.write(storeProperties, Arrays.asList("store.uuid=" + uuid, "store.version=" + String.valueOf(DataStoreLayout.VERSION)), StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (FileAlreadyExistsException e) {
            log.error("{} already exists in {}. Newly attached stores should be empty.", new Object[]{"store.properties", path, e});
            throw new DataStoreAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.propertiesexist", new Object[]{"store.properties", path}));
        }
        catch (IOException e) {
            log.error("Cannot write to {}; check your filesystem permissions and try again", (Object)path, (Object)e);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.notwritable", new Object[]{Product.NAME, path}));
        }
        if (this.clusterService.isClustered()) {
            ValidateDataStoreCallback callback = new ValidateDataStoreCallback(this.i18nService, path);
            this.executorService.submitToMembers((Callable)new ValidateDataStore(path.toString(), uuid), (MemberSelector)callback, (MultiExecutionCallback)callback);
            try {
                Map<ClusterNode, KeyedMessage> errors = callback.await(this.validationTimeout, TimeUnit.SECONDS);
                if (!errors.isEmpty()) {
                    MoreFiles.deleteQuietly((Path)storeProperties);
                    throw new InvalidDataStoreException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.cluster.validationfailed", new Object[]{path}), errors);
                }
            }
            catch (InterruptedException e) {
                MoreFiles.deleteQuietly((Path)storeProperties);
                log.error("Interrupted while validating {} on other nodes", (Object)path, (Object)e);
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.cluster.validationinterrupted", new Object[]{path}));
            }
            catch (TimeoutException e) {
                MoreFiles.deleteQuietly((Path)storeProperties);
                log.error("Timed out while validating {} on other nodes", (Object)path, (Object)e);
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.cluster.validationtimedout", new Object[]{path}));
            }
        }
        if ((cancelState = this.listenerRegistry.raiseOnAttach((DataStore)(dataStore = new InternalDataStore.Builder(path).uuid(uuid).build()))).isCanceled()) {
            MoreFiles.deleteQuietly((Path)storeProperties);
            throw new ArgumentValidationException(this.getCancellationMessage(cancelState));
        }
        InternalDataStore savedDataStore = (InternalDataStore)this.storeDao.create((Object)dataStore);
        final long storeId = savedDataStore.getId();
        this.synchronizer.register(new TransactionSynchronization(){

            public void afterCommit() {
                DefaultDataStoreService.this.raiseOnAttachedClusterWide(storeId);
            }
        });
        return savedDataStore;
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public DataStoreConfig getConfig() {
        InternalDataStore sharedHome = new InternalDataStore.Builder(this.homeLayout.getSharedHomeDir()).id(0L).type(DataStoreType.SHARED_HOME).uuid(UUID_SHARED_HOME).build();
        return new SimpleDataStoreConfig.Builder((DataStore)sharedHome).additional((Iterable)this.storeDao.listAll()).build();
    }

    private KeyedMessage getCancellationMessage(SimpleCancelState cancelState) {
        List messages = cancelState.getCancelMessages();
        StringBuilder builder = new StringBuilder("Attaching a data store was canceled:");
        messages.forEach(message -> builder.append("\n- ").append(message.getRootMessage()));
        log.warn(builder.toString());
        return (KeyedMessage)messages.get(messages.size() - 1);
    }

    private void raiseOnAttachedClusterWide(final long storeId) {
        if (!this.clusterService.isClustered()) {
            this.raiseOnAttached(storeId);
            return;
        }
        this.executorService.submitToAllMembers((Runnable)new RaiseOnAttached(storeId), new MultiExecutionCallback(){

            public void onResponse(Member member, Object value) {
                if (value instanceof Throwable) {
                    log.warn("Failed to trigger DataStoreListener.onAttached for data store {} on node (id={}, address={})", new Object[]{storeId, member.getUuid(), member.getSocketAddress(EndpointQualifier.MEMBER)});
                } else {
                    log.debug("Triggered DataStoreListener.onAttached for data store {} on node (id={}, address={})", new Object[]{storeId, member.getUuid(), member.getSocketAddress(EndpointQualifier.MEMBER)});
                }
            }

            public void onComplete(Map<Member, Object> values) {
            }
        });
    }

    private static boolean isNested(Path path, Path test) {
        try {
            test = test.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            log.warn("Could not convert {} to a real path", (Object)test, (Object)e);
        }
        return path.startsWith(test) || test.startsWith(path);
    }

    private InternalDataStore chooseStoreByUsableSpace() {
        InternalDataStore chosen = null;
        long maxUsable = 0L;
        for (InternalDataStore dataStore : this.storeDao.listAll()) {
            long usable = dataStore.getUsableSpace().orElse(-1L);
            if (usable <= maxUsable) continue;
            maxUsable = usable;
            chosen = dataStore;
        }
        return chosen;
    }

    @Transactional(readOnly=true)
    public void raiseOnAttached(long storeId) {
        InternalDataStore dataStore = (InternalDataStore)this.storeDao.getById((Object)storeId);
        if (dataStore != null) {
            this.listenerRegistry.raiseOnAttached((DataStore)dataStore);
        } else {
            log.warn("Failed to trigger onAttached for data store with ID {}. The data store was not found", (Object)storeId);
        }
    }

    private void verifyDirectory(Path path) throws IOException {
        BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        if (attributes.isRegularFile()) {
            log.warn("{} is a file and cannot be used as a data store", (Object)path);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.invalidtype.file", new Object[]{path}));
        }
        if (attributes.isSymbolicLink()) {
            log.warn("{} is a symbolic link and cannot be used as a data store", (Object)path);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.invalidtype.symlink", new Object[]{path}));
        }
        if (!attributes.isDirectory()) {
            log.warn("{} is not a directory and cannot be used as a data store", (Object)path);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.invalidtype.unknown", new Object[]{path}));
        }
    }

    private void verifyNotNested(Path path) {
        Path sharedHome = this.homeLayout.getSharedHomeDir();
        if (DefaultDataStoreService.isNested(path, sharedHome)) {
            log.warn("{} is nested with the shared home ({}) and cannot be used as a data store", (Object)path, (Object)sharedHome);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.nested.sharedhome", new Object[]{path, Product.NAME, sharedHome}));
        }
        for (InternalDataStore store : this.storeDao.listAll()) {
            if (!DefaultDataStoreService.isNested(path, store.getDir())) continue;
            log.warn("{} is nested with an existing data store ({}); stores may not be nested", (Object)path, (Object)store.getPath());
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.nested.otherstore", new Object[]{path, store.getPath()}));
        }
    }

    private void verifyRealPath(Path path) throws IOException {
        Path realPath = path.toRealPath(new LinkOption[0]);
        if (!path.toString().equals(realPath.toString())) {
            log.warn("{} does not match the directory's real path ({})", (Object)path, (Object)realPath);
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.storage.datastore.userealpath", new Object[]{path, realPath}));
        }
    }

    private static class ValidateDataStoreCallback
    implements MultiExecutionCallback,
    MemberSelector {
        private final Map<ClusterNode, KeyedMessage> errors;
        private final I18nService i18nService;
        private final CountDownLatch latch;
        private final Path path;
        private final Set<Member> pending;

        ValidateDataStoreCallback(I18nService i18nService, Path path) {
            this.i18nService = i18nService;
            this.path = path;
            this.errors = new ConcurrentHashMap<ClusterNode, KeyedMessage>();
            this.latch = new CountDownLatch(1);
            this.pending = new HashSet<Member>();
        }

        public void onResponse(@Nonnull Member member, Object error) {
            this.pending.remove(member);
            if (error != null) {
                SerializableI18nKey errorKey;
                if (error instanceof Throwable) {
                    errorKey = new SerializableI18nKey("bitbucket.storage.datastore.validationfailed", new Serializable[]{Product.NAME, this.path.toString()});
                    log.error("{} failed to validate {}", new Object[]{ValidateDataStoreCallback.memberToString(member), this.path, error});
                } else {
                    errorKey = (SerializableI18nKey)error;
                    log.error("{} failed to validate {}: {}", new Object[]{ValidateDataStoreCallback.memberToString(member), this.path, this.i18nService.getMessage(Locale.US, errorKey.getKey(), errorKey.getArguments())});
                }
                KeyedMessage keyedMessage = this.i18nService.createKeyedMessage(errorKey.getKey(), errorKey.getArguments());
                this.errors.put(NutclusterClusterNode.transform(member), keyedMessage);
            }
        }

        public void onComplete(Map<Member, Object> results) {
            this.latch.countDown();
        }

        public boolean select(Member member) {
            if (member.localMember()) {
                return false;
            }
            this.pending.add(member);
            return true;
        }

        Map<ClusterNode, KeyedMessage> await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            if (this.latch.await(timeout, unit)) {
                return this.errors;
            }
            HashSet<Member> incomplete = new HashSet<Member>(this.pending);
            if (incomplete.isEmpty()) {
                return this.errors;
            }
            log.error("Validation timed out for the following member(s):\n{}", (Object)incomplete.stream().map(ValidateDataStoreCallback::memberToString).collect(Collectors.joining("\n", "\t", "")));
            throw new TimeoutException();
        }

        private static String memberToString(Member member) {
            NutclusterClusterNode node = new NutclusterClusterNode(member);
            String name = node.getName();
            String identifier = node.getId() + "@" + String.valueOf(node.getAddress());
            return StringUtils.isEmpty((CharSequence)name) ? identifier : name + " (" + identifier + ")";
        }
    }

    @SpringAware
    private static final class ValidateDataStore
    implements Callable<SerializableI18nKey>,
    Serializable {
        private final String path;
        private final String uuid;
        private volatile transient HomeLayout homeLayout;

        ValidateDataStore(String path, String uuid) {
            this.path = path;
            this.uuid = uuid;
        }

        @Override
        public SerializableI18nKey call() {
            Path path = Paths.get(this.path, new String[0]);
            try {
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (attributes.isRegularFile()) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.invalidtype.file", new Serializable[]{this.path});
                }
                if (attributes.isSymbolicLink()) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.invalidtype.symlink", new Serializable[]{this.path});
                }
                if (!attributes.isDirectory()) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.invalidtype.unknown", new Serializable[]{this.path});
                }
                Path realPath = path.toRealPath(new LinkOption[0]);
                if (!this.path.equals(realPath.toString())) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.userealpath", new Serializable[]{this.path, realPath.toString()});
                }
                Path sharedHome = this.homeLayout.getSharedHomeDir();
                if (DefaultDataStoreService.isNested(path, sharedHome)) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.nested.sharedhome", new Serializable[]{this.path, Product.NAME, sharedHome.toString()});
                }
                Properties properties = new Properties();
                try (BufferedReader reader = Files.newBufferedReader(path.resolve("store.properties"), StandardCharsets.UTF_8);){
                    properties.load(reader);
                }
                String storeUuid = properties.getProperty("store.uuid");
                if (!this.uuid.equals(storeUuid)) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.uuidmismatch", new Serializable[]{storeUuid, this.uuid});
                }
                String storeVersion = properties.getProperty("store.version");
                if (storeVersion == null) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.versioninvalid", new Serializable[]{"store.properties"});
                }
                if (DataStoreLayout.VERSION.getMajor() < new Version(storeVersion).getMajor()) {
                    return new SerializableI18nKey("bitbucket.storage.datastore.versionunsupported", new Serializable[]{storeVersion, Integer.valueOf(DataStoreLayout.VERSION.getMajor())});
                }
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                return new SerializableI18nKey("bitbucket.storage.datastore.propertiesnotexist", new Serializable[]{"store.properties"});
            }
            catch (IOException e) {
                log.error("{}", (Object)path, (Object)e);
                return new SerializableI18nKey("bitbucket.storage.datastore.validationfailed", new Serializable[]{Product.NAME, this.path});
            }
            return null;
        }

        @Autowired
        public void setHomeLayout(HomeLayout homeLayout) {
            this.homeLayout = homeLayout;
        }
    }

    @SpringAware
    private static class RaiseOnAttached
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long storeId;
        private volatile transient InternalDataStoreService dataStoreService;

        RaiseOnAttached(long storeId) {
            this.storeId = storeId;
        }

        @Override
        public void run() {
            this.dataStoreService.raiseOnAttached(this.storeId);
        }

        @Autowired
        void setDataStoreService(InternalDataStoreService dataStoreService) {
            this.dataStoreService = dataStoreService;
        }
    }

    private static class SerializableI18nKey
    implements Serializable {
        private final Serializable[] arguments;
        private final String key;

        private SerializableI18nKey(@Nonnull String key, Serializable ... arguments) {
            this.arguments = arguments;
            this.key = key;
        }

        public SerializableI18nKey() {
            this.arguments = null;
            this.key = null;
        }

        @Nonnull
        public Object[] getArguments() {
            return this.arguments;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }
    }
}

