/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.stash.internal.server.OperatingSystemService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.lang.management.ManagementFactory;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="operatingSystemService")
public class DefaultOperatingSystemService
implements OperatingSystemService {
    private static final Logger log = LoggerFactory.getLogger(DefaultOperatingSystemService.class);
    private static final String ATTR_SYSTEM_CPU_LOAD = "SystemCpuLoad";
    private static final String ATTR_TOTAL_PHYSICAL_MEMORY_SIZE = "TotalPhysicalMemorySize";
    private final ObjectName osName = ObjectName.getInstance("java.lang:type=OperatingSystem");
    private final OptionalNumericalAttribute<Double> systemCpuLoad = new OptionalNumericalAttribute(value -> {
        if (value == null) {
            return Optional.empty();
        }
        double asDouble = value.doubleValue();
        if (Double.compare(asDouble, 0.0) < 0 || Double.compare(asDouble, 1.0) > 0) {
            return Optional.empty();
        }
        return Optional.of(asDouble);
    }, "SystemCpuLoad");
    private final OptionalNumericalAttribute<Long> physicalMem = new OptionalNumericalAttribute(value -> {
        if (value == null) {
            return Optional.empty();
        }
        long asLong = value.longValue();
        if (asLong <= 0L) {
            return Optional.empty();
        }
        return Optional.of(asLong);
    }, "TotalPhysicalMemorySize");

    public DefaultOperatingSystemService() throws MalformedObjectNameException {
        OptionalDouble cpuLoad = this.getCpuLoad();
        log.debug("Pre-fetch of CPU load: {}", !cpuLoad.isPresent() ? "not available" : Double.valueOf(cpuLoad.getAsDouble()));
    }

    @Nonnull
    public OptionalDouble getCpuLoad() {
        return this.systemCpuLoad.getValue().map(OptionalDouble::of).orElse(OptionalDouble.empty());
    }

    @Nonnull
    public OptionalLong getTotalPhysicalMemory() {
        return this.physicalMem.getValue().map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    @VisibleForTesting
    AttributeList getAttribute(String name) throws InstanceNotFoundException, ReflectionException {
        return ManagementFactory.getPlatformMBeanServer().getAttributes(this.osName, new String[]{name});
    }

    class OptionalNumericalAttribute<V> {
        private final Function<Number, Optional<V>> converter;
        private final AtomicBoolean lastAvailable;
        private final AtomicBoolean loggedFirstAbsentValue;
        private final String name;

        public OptionalNumericalAttribute(Function<Number, Optional<V>> converter, String name) {
            this.converter = converter;
            this.name = name;
            this.lastAvailable = new AtomicBoolean(true);
            this.loggedFirstAbsentValue = new AtomicBoolean(false);
        }

        public Optional<V> getValue() {
            try {
                AttributeList list = DefaultOperatingSystemService.this.getAttribute(this.name);
                if (list.isEmpty()) {
                    if (this.loggedFirstAbsentValue.compareAndSet(false, true)) {
                        log.debug("Attribute {} on {} is not available", (Object)this.name, (Object)DefaultOperatingSystemService.this.osName);
                    }
                    return Optional.empty();
                }
                Attribute att = (Attribute)list.get(0);
                Number value = att.getValue() instanceof Number ? (Number)((Number)att.getValue()) : (Number)null;
                Optional<V> optionalValue = this.converter.apply(value);
                if (!optionalValue.isPresent()) {
                    if (this.lastAvailable.compareAndSet(true, false)) {
                        log.debug("Attribute {} on {} is not available. Value returned: {}", new Object[]{this.name, DefaultOperatingSystemService.this.osName, value});
                    }
                    return Optional.empty();
                }
                if (this.lastAvailable.compareAndSet(false, true)) {
                    log.debug("Attribute {} on {} is once again available. Value returned: {}", new Object[]{this.name, DefaultOperatingSystemService.this.osName, value});
                }
                return optionalValue;
            }
            catch (InstanceNotFoundException | ReflectionException e) {
                if (this.loggedFirstAbsentValue.compareAndSet(false, true)) {
                    log.error("Failed to query attribute {} on {}", new Object[]{this.name, DefaultOperatingSystemService.this.osName, e});
                }
                return Optional.empty();
            }
        }
    }
}

