/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.profiling.DmzProfilingService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.profiling.ProfilingService;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.nutcluster.core.EntryAdapter;
import com.atlassian.nutcluster.core.EntryEvent;
import com.atlassian.nutcluster.core.EntryListener;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.server.ProfilingSettingsChangedEvent;
import com.atlassian.util.profiling.ProfilerConfiguration;
import com.atlassian.util.profiling.Timers;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@AvailableToPlugins(interfaces={ProfilingService.class, DmzProfilingService.class})
@Component(value="profilingService")
public class DefaultProfilingService
implements DmzProfilingService {
    public static final String MAP_PROFILING = "profiling.state";
    private static final String KEY_ENABLED = "enabled";
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final String entryListenerSubscription;
    private final EventPublisher eventPublisher;
    private final int maxFrameNameLength;
    private final long minFrameMillis;
    private final long minTraceMillis;
    private final ProfilerConfiguration profilerConfiguration;
    private final IMap<String, Boolean> profilingState;
    private final SecurityService securityService;

    @Autowired
    public DefaultProfilingService(InternalApplicationPropertiesService applicationPropertiesService, NutclusterInstance nutclusterInstance, EventPublisher eventPublisher, SecurityService securityService, @Value(value="${atlassian.profile.maxframenamelength}") int maxFrameNameLength, @Value(value="${atlassian.profile.mintime}") long minFrameMillis, @Value(value="${atlassian.profile.mintotaltime}") long minTraceMillis) {
        this(applicationPropertiesService, nutclusterInstance, eventPublisher, securityService, maxFrameNameLength, minFrameMillis, minTraceMillis, Timers.getConfiguration());
    }

    @VisibleForTesting
    protected DefaultProfilingService(InternalApplicationPropertiesService applicationPropertiesService, NutclusterInstance nutclusterInstance, EventPublisher eventPublisher, SecurityService securityService, int maxFrameNameLength, long minFrameMillis, long minTraceMillis, ProfilerConfiguration profilerConfiguration) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.eventPublisher = eventPublisher;
        this.securityService = securityService;
        this.profilerConfiguration = profilerConfiguration;
        this.maxFrameNameLength = Math.max(150, maxFrameNameLength);
        this.minFrameMillis = Math.max(0L, minFrameMillis);
        this.minTraceMillis = Math.max(this.minFrameMillis, minTraceMillis);
        this.profilingState = nutclusterInstance.getMap(MAP_PROFILING);
        this.entryListenerSubscription = this.profilingState.addEntryListener((EntryListener)new ProfilingStateListener(), true);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public boolean isProfilingEnabled() {
        return this.profilingState.containsKey((Object)KEY_ENABLED);
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void setProfilingEnabled(boolean enabled) {
        this.applicationPropertiesService.setProfilingEnabled(enabled);
        this.enableProfiling(enabled);
    }

    @PostConstruct
    @VisibleForTesting
    protected void onStartup() {
        if (this.profilingState.containsKey((Object)KEY_ENABLED)) {
            this.updateProfilingConfig(true);
            this.persistProfilingSettingIfMirror(true);
        } else if (this.applicationPropertiesService.isProfilingEnabled()) {
            this.persistProfilingSettingSecured(true);
            this.enableProfiling(true);
        }
    }

    private void enableProfiling(boolean enabled) {
        boolean wasEnabled = this.profilingState.containsKey((Object)KEY_ENABLED);
        if (enabled) {
            this.profilingState.put((Object)KEY_ENABLED, (Object)true);
        } else {
            this.profilingState.remove((Object)KEY_ENABLED);
        }
        this.updateProfilingConfig(enabled);
        if (enabled != wasEnabled) {
            this.publishSettingsChangedEvent(enabled);
        }
    }

    @PreDestroy
    private void onShutdown() {
        this.profilingState.removeEntryListener(this.entryListenerSubscription);
    }

    private void persistProfilingSettingIfMirror(boolean enabled) {
        if (this.applicationPropertiesService.getMode() == ApplicationMode.MIRROR) {
            this.persistProfilingSettingSecured(enabled);
        }
    }

    private void persistProfilingSettingSecured(boolean enabled) {
        this.securityService.withPermission(Permission.SYS_ADMIN, "Persisting profiling state").call(() -> {
            this.applicationPropertiesService.setProfilingEnabled(enabled);
            return null;
        });
    }

    private void publishSettingsChangedEvent(boolean profilingEnabled) {
        if (this.applicationPropertiesService.getMode() == ApplicationMode.MIRROR) {
            this.securityService.withPermission(Permission.SYS_ADMIN, "Publishing profiling settings changed event").call(() -> {
                this.eventPublisher.publish((Object)new ProfilingSettingsChangedEvent((Object)this, profilingEnabled));
                return null;
            });
        } else {
            this.eventPublisher.publish((Object)new ProfilingSettingsChangedEvent((Object)this, profilingEnabled));
        }
    }

    private void updateProfilingConfig(boolean enabled) {
        this.profilerConfiguration.setEnabled(enabled);
        if (enabled) {
            this.profilerConfiguration.setMaxFrameNameLength(this.maxFrameNameLength);
            this.profilerConfiguration.setMinFrameTime(this.minFrameMillis, TimeUnit.MILLISECONDS);
            this.profilerConfiguration.setMinTraceTime(this.minTraceMillis, TimeUnit.MILLISECONDS);
        }
    }

    private class ProfilingStateListener
    extends EntryAdapter<String, Boolean> {
        private ProfilingStateListener() {
        }

        public void entryAdded(EntryEvent<String, Boolean> event) {
            this.entryUpdated(event);
        }

        public void entryEvicted(EntryEvent<String, Boolean> event) {
        }

        public void entryRemoved(EntryEvent<String, Boolean> event) {
            if (((String)event.getKey()).equals(DefaultProfilingService.KEY_ENABLED) && !event.getMember().localMember()) {
                DefaultProfilingService.this.updateProfilingConfig(false);
                DefaultProfilingService.this.persistProfilingSettingIfMirror(false);
            }
        }

        public void entryUpdated(EntryEvent<String, Boolean> event) {
            if (((String)event.getKey()).equals(DefaultProfilingService.KEY_ENABLED) && !event.getMember().localMember()) {
                DefaultProfilingService.this.updateProfilingConfig(true);
                DefaultProfilingService.this.persistProfilingSettingIfMirror(true);
            }
        }
    }
}

