/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.server.DataStoreLayout;
import com.atlassian.stash.internal.server.InternalStorageService;
import jakarta.annotation.Nonnull;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(interfaces={StorageService.class, DmzStorageService.class})
@Service(value="storageService")
public class DefaultStorageService
implements InternalStorageService {
    private static final String PATH_REPOSITORY = "repository";
    private final HomeLayout homeLayout;

    @Autowired
    public DefaultStorageService(HomeLayout homeLayout) {
        this.homeLayout = homeLayout;
    }

    @Nonnull
    public Path getAttachmentsDir(@Nonnull Repository repository) {
        return InternalConverter.convertToInternalRepository((Repository)repository).getDataStore().map(DataStoreLayout::getAttachmentsDir).orElseGet(() -> ((HomeLayout)this.homeLayout).getAttachmentsDir()).resolve(PATH_REPOSITORY).resolve(String.valueOf(repository.getId()));
    }

    @Nonnull
    public Path getBinDir() {
        return this.homeLayout.getBinDir();
    }

    @Nonnull
    public Path getCacheDir() {
        return this.homeLayout.getCacheDir();
    }

    @Nonnull
    public Path getConfigDir() {
        return this.homeLayout.getConfigDir();
    }

    @Nonnull
    public Path getDataDir() {
        return this.homeLayout.getDataDir();
    }

    @Nonnull
    public Path getHierarchyDataDir(@Nonnull String hierarchyId) {
        return this.homeLayout.getHierarchyDataDir(hierarchyId);
    }

    @Nonnull
    public Path getHierarchyDataDir(@Nonnull Repository repository) {
        return this.homeLayout.getHierarchyDataDir(repository);
    }

    @Nonnull
    public Optional<Path> getHierarchyDir(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, PATH_REPOSITORY);
        return InternalConverter.convertToInternalRepository((Repository)repository).getDataStore().map(store -> DataStoreLayout.getHierarchyDir((DataStore)store, (String)repository.getHierarchyId()));
    }

    @Nonnull
    public Path getHomeDir() {
        return this.homeLayout.getHomeDir();
    }

    @Nonnull
    public Path getRepositoryDir(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, PATH_REPOSITORY);
        return InternalConverter.convertToInternalRepository((Repository)repository).getDataStore().map(store -> DataStoreLayout.getRepositoryDir((DataStore)store, (Repository)repository)).orElseGet(() -> this.homeLayout.getRepositoryDir(repository));
    }

    @Nonnull
    public Path getSharedHomeDir() {
        return this.homeLayout.getSharedHomeDir();
    }

    @Nonnull
    public Path getTempDir() {
        return this.homeLayout.getTempDir();
    }
}

