/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.common.LicensePropertiesConstants;
import com.atlassian.extras.decoder.v2.Version2LicenseDecoder;
import com.atlassian.stash.internal.license.LicenseRetrievalDao;
import com.atlassian.stash.internal.license.UnsupportedLicenseException;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class LicenseValidator
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(LicenseValidator.class);
    private final LicenseRetrievalDao licenseDao;
    private Environment environment;

    public LicenseValidator(LicenseRetrievalDao licenseDao) {
        this.licenseDao = licenseDao;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void validate() {
        if (Objects.equals(this.environment.getProperty("application.mode"), ApplicationMode.MIRROR.getId())) {
            log.debug("Mirror application, skipping license validation");
            return;
        }
        String license = this.licenseDao.getLicense();
        if (license == null) {
            log.debug("Fresh startup, skipping license validation");
            return;
        }
        Version2LicenseDecoder decoder = new Version2LicenseDecoder(false, false);
        Properties decode = decoder.decode(license);
        if (!Boolean.parseBoolean(decode.getProperty(LicensePropertiesConstants.getKey((Product)Product.STASH, (String)"DataCenter")))) {
            throw new UnsupportedLicenseException("This Bitbucket version no longer supports Server licenses");
        }
        log.debug("Successfully validated license");
    }
}

