/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.StrategiesRegistry;
import com.atlassian.util.profiling.micrometer.MicrometerStrategy;
import com.atlassian.util.profiling.micrometer.analytics.AnalyticsMeterRegistry;
import com.atlassian.util.profiling.micrometer.analytics.AnalyticsRegistryConfig;
import com.atlassian.util.profiling.micrometer.util.QualifiedCompatibleHierarchicalNameMapper;
import com.atlassian.util.profiling.micrometer.util.UnescapedObjectNameFactory;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import jakarta.annotation.PostConstruct;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Component(value="micrometerMetrics")
public class MicrometerMetrics {
    private final ApplicationPropertiesService propertiesService;
    private final EventPublisher eventPublisher;

    @Autowired
    public MicrometerMetrics(ApplicationPropertiesService propertiesService, EventPublisher eventPublisher) {
        this.propertiesService = propertiesService;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public final void onStartup() {
        if (this.propertiesService.isJmxEnabled()) {
            AnalyticsMeterRegistry analyticsMeterRegistry = new AnalyticsMeterRegistry(AnalyticsRegistryConfig.DEFAULT, this.eventPublisher);
            JmxMeterRegistry jmxMeterRegistry = MicrometerMetrics.createJmxRegistry();
            CompositeMeterRegistry compositeMeterRegistry = new CompositeMeterRegistry();
            compositeMeterRegistry.add((MeterRegistry)analyticsMeterRegistry);
            compositeMeterRegistry.add((MeterRegistry)jmxMeterRegistry);
            StrategiesRegistry.addMetricStrategy((MetricStrategy)new MicrometerStrategy((MeterRegistry)compositeMeterRegistry));
        }
    }

    private static JmxMeterRegistry createJmxRegistry() {
        MetricRegistry metricRegistry = new MetricRegistry();
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain("com.atlassian.bitbucket").createsObjectNamesWith((ObjectNameFactory)new UnescapedObjectNameFactory()).build();
        QualifiedCompatibleHierarchicalNameMapper nameMapper = new QualifiedCompatibleHierarchicalNameMapper();
        JmxMeterRegistry registry = new JmxMeterRegistry(JmxConfig.DEFAULT, Clock.SYSTEM, (HierarchicalNameMapper)nameMapper, metricRegistry, jmxReporter);
        registry.config().namingConvention(NamingConvention.dot).meterFilter(MeterFilter.ignoreTags((String[])new String[]{MetricTag.SEND_ANALYTICS.getKey()})).onMeterRemoved(MicrometerMetrics.getMeterCleanupConsumer(metricRegistry, (HierarchicalNameMapper)nameMapper, registry));
        return registry;
    }

    private static Consumer<Meter> getMeterCleanupConsumer(MetricRegistry metricRegistry, HierarchicalNameMapper nameMapper, JmxMeterRegistry registry) {
        return meter -> {
            if (meter instanceof LongTaskTimer) {
                for (Statistic statistic : Statistic.values()) {
                    metricRegistry.remove(nameMapper.toHierarchicalName(meter.getId().withTag(statistic), registry.config().namingConvention()));
                }
            }
        };
    }
}

