/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.stash.internal.config.ObsoleteConfigurationPropertyException;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class ObsoleteSecretManagementPropertyValidator
implements EnvironmentAware {
    private static final Set<String> OBSOLETE_PROPERTIES = Set.of("encrypted-property.cipher.classname", "jdbc.password.decrypter.classname");
    private Environment environment;

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    public void validate() {
        OBSOLETE_PROPERTIES.forEach(this::validate);
    }

    private void validate(String obsoleteProperty) {
        if (StringUtils.isNotBlank((CharSequence)this.environment.getProperty(obsoleteProperty))) {
            throw new ObsoleteConfigurationPropertyException(obsoleteProperty, "secrets.secured-properties");
        }
    }
}

