/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.event.server.OperatingSystemChangedEvent;
import com.atlassian.bitbucket.server.OperatingSystem;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OperatingSystemTracker {
    private static final String LOCK_NAME = OperatingSystemTracker.class.getName() + ".os.check";
    private static final Logger log = LoggerFactory.getLogger(OperatingSystemTracker.class);
    private final InternalApplicationPropertiesService applicationPropertiesService;
    private final EventPublisher eventPublisher;
    private final LockService lockService;

    @Autowired
    public OperatingSystemTracker(InternalApplicationPropertiesService applicationPropertiesService, EventPublisher eventPublisher, LockService lockService) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.eventPublisher = eventPublisher;
        this.lockService = lockService;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        try (LockGuard ignored1 = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_NAME));){
            OperatingSystem current = OperatingSystemTracker.currentOs();
            OperatingSystem previous = this.applicationPropertiesService.getLastOperatingSystem();
            if (previous == null) {
                log.info("Capturing benchmark operating system: {}", (Object)OperatingSystemTracker.currentOs());
                this.applicationPropertiesService.setLastOperatingSystem(current);
            } else if (!previous.equals((Object)current)) {
                log.warn("The operating system has been migrated from {} to {}", (Object)previous, (Object)OperatingSystemTracker.currentOs());
                this.eventPublisher.publish((Object)new OperatingSystemChangedEvent((Object)this, current, previous));
                this.applicationPropertiesService.setLastOperatingSystem(current);
            }
        }
    }

    private static OperatingSystem currentOs() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return OperatingSystem.WINDOWS;
        }
        if (SystemUtils.IS_OS_MAC) {
            return OperatingSystem.MAC_OS;
        }
        return OperatingSystem.LINUX;
    }
}

