/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.dmz.features.DmzFeatureManager;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@AvailableToPlugins(interfaces={FeatureManager.class, DmzFeatureManager.class})
@Component(value="featureManager")
public class PropertyFeatureManager
implements DmzFeatureManager,
EnvironmentAware {
    static final String PROP_PREFIX = "feature.";
    private Environment environment;
    private ConcurrentMap<String, Boolean> features;
    private I18nService i18nService;

    @PostConstruct
    public void initialize() {
        this.features = this.loadFeatures();
    }

    public boolean isDisabled(@Nonnull Feature feature) {
        Objects.requireNonNull(feature, "feature");
        return this.isDisabled(feature, true);
    }

    public boolean isDisabled(@Nonnull Feature feature, boolean defaultValue) {
        Objects.requireNonNull(feature, "feature");
        Boolean enabled = this.getValue(feature);
        if (enabled == null) {
            return defaultValue;
        }
        return enabled == false;
    }

    public boolean isEnabled(@Nonnull Feature feature) {
        return this.isEnabled(feature, false);
    }

    public boolean isEnabled(@Nonnull Feature feature, boolean defaultValue) {
        Objects.requireNonNull(feature, "feature");
        Boolean enabled = this.getValue(feature);
        if (enabled == null) {
            return defaultValue;
        }
        return enabled;
    }

    public void reload() {
        this.features = this.loadFeatures();
    }

    public void requireEnabled(@Nonnull Feature feature) {
        this.requireEnabled(feature, false);
    }

    public void requireEnabled(@Nonnull Feature feature, boolean defaultValue) {
        Objects.requireNonNull(feature, "feature");
        if (this.isEnabled(feature, defaultValue)) {
            return;
        }
        throw new FeatureDisabledException(this.i18nService.createKeyedMessage("bitbucket.feature.disabled", new Object[]{feature.getKey()}));
    }

    public void setEnvironment(@Nonnull Environment environment) {
        this.environment = environment;
    }

    @Autowired
    public void setI18nService(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    private Boolean getValue(@Nonnull Feature feature) {
        String enabledString;
        Boolean enabled = (Boolean)this.features.get(feature.getKey());
        if (enabled == null && (enabledString = this.environment.getProperty(PROP_PREFIX + feature.getKey())) != null) {
            this.features.putIfAbsent(feature.getKey(), Boolean.parseBoolean(enabledString));
            enabled = (Boolean)this.features.get(feature.getKey());
        }
        return enabled;
    }

    private ConcurrentMap<String, Boolean> loadFeatures() {
        ConcurrentMap features = Maps.newConcurrentMap();
        for (StandardFeature feature : StandardFeature.values()) {
            features.put(feature.getKey(), (Boolean)this.environment.getProperty(PROP_PREFIX + feature.getKey(), Boolean.class, (Object)Boolean.FALSE));
        }
        return features;
    }
}

