/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandlerModuleDescriptor;
import com.atlassian.bitbucket.dmz.server.DmzDataStoreService;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.timezone.TimeZoneService;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.db.DetailedDatabase;
import com.atlassian.stash.internal.server.ServerSupportDataFsUtils;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="serverSupportData")
public class ServerSupportData
extends RootLevelSupportDataAppender {
    private static final String GENERAL_INFO = "bitbucket.atst.info";
    private static final String APPLICATION_BASE_URL = "bitbucket.atst.base.url";
    private static final String APPLICATION_BUILD_NUMBER = "bitbucket.atst.build.number";
    private static final String APPLICATION_BUILD_TIMESTAMP = "bitbucket.atst.build.timestamp";
    private static final String APPLICATION_BUILD_VERSION = "bitbucket.atst.build.version";
    private static final String APPLICATION_DISPLAY_NAME = "bitbucket.atst.display.name";
    private static final String DEFAULT_TIME_ZONE = "bitbucket.atst.time.zone";
    private static final String CAPTCHA_MAX_ATTEMPTS = "bitbucket.atst.captcha.max.attempts";
    private static final String COMMIT_HASH = "bitbucket.atst.commit.hash";
    private static final String CPUS = "bitbucket.atst.cpus";
    private static final String JVM_TIME_ZONE = "bitbucket.atst.jvm.time.zone";
    private static final String LICENSE_SEN = "bitbucket.atst.license.sen";
    private static final String LICENSE_SERVER_ID = "bitbucket.atst.license.server.id";
    private static final String DATA_STORE = "bitbucket.atst.datastore";
    private static final String DATA_STORES = "bitbucket.atst.datastores";
    private static final String DATA_STORE_PATH = "bitbucket.atst.datastore.path";
    private static final String DATA_STORE_UUID = "bitbucket.atst.datastore.uuid";
    private static final String DB = "bitbucket.atst.db";
    private static final String DB_CONNECTION_URL = "bitbucket.atst.db.connection.url";
    private static final String DB_DRIVER = "bitbucket.atst.db.driver";
    private static final String DB_DRIVER_NAME = "bitbucket.atst.db.driver.name";
    private static final String DB_DRIVER_VERSION = "bitbucket.atst.db.driver.version";
    private static final String DB_NAME = "bitbucket.atst.db.name";
    private static final String DB_SUPPORT_LEVEL = "bitbucket.atst.db.support.level";
    private static final String DB_VERSION = "bitbucket.atst.db.version";
    private static final String HTTP = "bitbucket.atst.http";
    private static final String HTTP_AUTHENTICATION_HANDLERS = "bitbucket.atst.http.authentication-handlers";
    private static final String HTTP_FAILURE_HANDLERS = "bitbucket.atst.http.failure-handlers";
    private static final String HTTP_HANDLER = "bitbucket.atst.http.handler";
    private static final String HTTP_HANDLER_CLASS = "bitbucket.atst.http.handler.class";
    private static final String HTTP_HANDLER_ENABLED = "bitbucket.atst.http.handler.enabled";
    private static final String HTTP_HANDLER_KEY = "bitbucket.atst.http.handler.key";
    private static final String HTTP_HANDLER_PLUGIN = "bitbucket.atst.http.handler.plugin";
    private static final String HTTP_HANDLER_WEIGHT = "bitbucket.atst.http.handler.weight";
    private static final String HTTP_SCM_HOSTING = "bitbucket.atst.http.scm";
    private static final String HTTP_SCM_HOSTING_ENABLED = "bitbucket.atst.http.scm.enabled";
    private static final String HTTP_SUCCESS_HANDLERS = "bitbucket.atst.http.success-handlers";
    private static final String FS_INFO = "bitbucket.atst.fs";
    private static final String FS_DESCRIPTION = "bitbucket.atst.fs.description";
    private static final String FS_HOME = "bitbucket.atst.fs.home";
    private static final String FS_NAME = "bitbucket.atst.fs.name";
    private static final String FS_PATH = "bitbucket.atst.fs.path";
    private static final String FS_SHARED_HOME = "bitbucket.atst.fs.shared-home";
    private static final String FS_SIZE_FREE = "bitbucket.atst.fs.size.free";
    private static final String FS_SIZE_TOTAL = "bitbucket.atst.fs.size.total";
    private static final String FS_TYPE = "bitbucket.atst.fs.type";
    private static final String MOUNT_OPTIONS = "bitbucket.atst.fs.mount.options";
    private final DatabaseSupplier databaseSupplier;
    private final DmzDataStoreService dataStoreService;
    private final LicenseService licenseService;
    private final PluginAccessor pluginAccessor;
    private final ApplicationPropertiesService propertiesService;
    private final StorageService storageService;
    private final TimeZoneService timeZoneService;

    @Autowired
    public ServerSupportData(DatabaseSupplier databaseSupplier, DmzDataStoreService dataStoreService, LicenseService licenseService, PluginAccessor pluginAccessor, ApplicationPropertiesService propertiesService, StorageService storageService, TimeZoneService timeZoneService) {
        this.databaseSupplier = databaseSupplier;
        this.dataStoreService = dataStoreService;
        this.licenseService = licenseService;
        this.pluginAccessor = pluginAccessor;
        this.propertiesService = propertiesService;
        this.storageService = storageService;
        this.timeZoneService = timeZoneService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        this.addGeneralInformation(supportDataBuilder.addCategory(GENERAL_INFO));
        this.addFilesystemInformation(supportDataBuilder.addCategory(FS_INFO));
        this.addDataStores(supportDataBuilder);
        this.addDatabaseInformation(supportDataBuilder.addCategory(DB));
        this.addHttpInformation(supportDataBuilder.addCategory(HTTP));
    }

    private void addDatabaseInformation(SupportDataBuilder builder) {
        try {
            DetailedDatabase database = this.databaseSupplier.get();
            builder.addValue(DB_NAME, database.getName()).addValue(DB_VERSION, database.getVersion().toString()).addValue(DB_SUPPORT_LEVEL, database.getSupportLevel().toString());
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not database details", (Throwable)e);
        }
        builder.addValue(DB_CONNECTION_URL, this.propertiesService.getJdbcUrl());
        builder.addCategory(DB_DRIVER).addValue(DB_DRIVER_NAME, this.propertiesService.getJdbcDriver()).addValue(DB_DRIVER_VERSION, this.propertiesService.getJdbcDriverVersion());
    }

    private void addDataStores(SupportDataBuilder builder) {
        List dataStores = this.dataStoreService.getConfig().getAdditional();
        if (dataStores.isEmpty()) {
            return;
        }
        SupportDataBuilder storesBuilder = builder.addCategory(DATA_STORES);
        dataStores.forEach(dataStore -> {
            SupportDataBuilder storeBuilder = storesBuilder.addCategory(DATA_STORE).addValue(DATA_STORE_PATH, dataStore.getPath()).addValue(DATA_STORE_UUID, dataStore.getUuid());
            try {
                FileStore fileStore = Files.getFileStore(dataStore.getDir());
                storeBuilder.addCategory(FS_INFO).addValue(FS_NAME, (String)StringUtils.defaultIfBlank((CharSequence)fileStore.name(), (CharSequence)"-")).addValue(FS_DESCRIPTION, fileStore.toString()).addValue(FS_SIZE_FREE, NumberUtils.formatSize((double)fileStore.getUsableSpace())).addValue(FS_SIZE_TOTAL, NumberUtils.formatSize((double)fileStore.getTotalSpace())).addValue(FS_TYPE, fileStore.type());
                builder.addValue(MOUNT_OPTIONS, ServerSupportDataFsUtils.getMountOptions(fileStore, dataStore.getDir()));
            }
            catch (IOException e) {
                storeBuilder.addValue(FS_INFO, e.getClass().getSimpleName());
            }
        });
    }

    private void addFilesystemInformation(SupportDataBuilder builder) {
        this.addFilesystemInformation(builder.addCategory(FS_HOME), this.storageService.getHomeDir());
        this.addFilesystemInformation(builder.addCategory(FS_SHARED_HOME), this.storageService.getSharedHomeDir());
    }

    private void addFilesystemInformation(SupportDataBuilder builder, Path dir) {
        builder.addValue(FS_PATH, dir.toString());
        try {
            FileStore store = Files.getFileStore(dir);
            builder.addValue(FS_NAME, (String)StringUtils.defaultIfBlank((CharSequence)store.name(), (CharSequence)"-"));
            builder.addValue(FS_DESCRIPTION, store.toString());
            builder.addValue(FS_SIZE_FREE, NumberUtils.formatSize((double)store.getUsableSpace()));
            builder.addValue(FS_SIZE_TOTAL, NumberUtils.formatSize((double)store.getTotalSpace()));
            builder.addValue(FS_TYPE, store.type());
            builder.addValue(MOUNT_OPTIONS, ServerSupportDataFsUtils.getMountOptions(store, dir));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addGeneralInformation(SupportDataBuilder builder) {
        builder.addValue(APPLICATION_BASE_URL, String.valueOf(this.propertiesService.getBaseUrl()));
        builder.addValue(APPLICATION_BUILD_NUMBER, this.propertiesService.getBuildNumber());
        builder.addValue(APPLICATION_BUILD_TIMESTAMP, this.propertiesService.getBuildTimestamp().toString());
        builder.addValue(APPLICATION_BUILD_VERSION, this.propertiesService.getBuildVersion());
        builder.addValue(APPLICATION_DISPLAY_NAME, this.propertiesService.getDisplayName());
        builder.addValue(DEFAULT_TIME_ZONE, this.timeZoneService.getDefaultTimeZone().getId());
        builder.addValue(JVM_TIME_ZONE, this.timeZoneService.getJvmTimeZone().getId());
        builder.addValue(COMMIT_HASH, this.propertiesService.getCommitHash());
        builder.addValue(CAPTCHA_MAX_ATTEMPTS, String.valueOf(this.propertiesService.getMaxCaptchaAttempts()));
        builder.addValue(CPUS, String.valueOf(Runtime.getRuntime().availableProcessors()));
        BitbucketServerLicense license = this.licenseService.get();
        if (license != null) {
            builder.addValue(LICENSE_SERVER_ID, license.getServerId());
            builder.addValue(LICENSE_SEN, license.getSupportEntitlementNumber());
        }
    }

    private <D extends BaseWeightedModuleDescriptor<T>, T> void addHandlers(SupportDataBuilder builder, String category, Class<D> descriptorClass) {
        Collection descriptors = this.pluginAccessor.getModuleDescriptors(descriptorClass::isInstance);
        if (descriptors.isEmpty()) {
            return;
        }
        SupportDataBuilder handlers = builder.addCategory(category);
        descriptors.stream().map(descriptorClass::cast).sorted().forEach(descriptor -> {
            SupportDataBuilder handler = handlers.addCategory(HTTP_HANDLER).addValue(HTTP_HANDLER_PLUGIN, descriptor.getPluginKey()).addValue(HTTP_HANDLER_KEY, descriptor.getKey());
            if (descriptor.getModuleClass() != null) {
                handler.addValue(HTTP_HANDLER_CLASS, descriptor.getModuleClass().getName());
            }
            handler.addValue(HTTP_HANDLER_ENABLED, String.valueOf(descriptor.isEnabled())).addValue(HTTP_HANDLER_WEIGHT, String.valueOf(descriptor.getWeight()));
        });
    }

    private void addHttpInformation(SupportDataBuilder builder) {
        this.addHandlers(builder, HTTP_AUTHENTICATION_HANDLERS, HttpAuthenticationHandlerModuleDescriptor.class);
        this.addHandlers(builder, HTTP_FAILURE_HANDLERS, HttpAuthenticationFailureHandlerModuleDescriptor.class);
        this.addHandlers(builder, HTTP_SUCCESS_HANDLERS, HttpAuthenticationSuccessHandlerModuleDescriptor.class);
        builder.addCategory(HTTP_SCM_HOSTING).addValue(HTTP_SCM_HOSTING_ENABLED, String.valueOf(this.propertiesService.isHttpScmHostingEnabled()));
    }
}

