/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class ServerSupportDataFsUtils {
    private ServerSupportDataFsUtils() {
    }

    public static String getMountOptions(FileStore store, Path dir) throws IOException {
        String string;
        FileReader reader = new FileReader("/proc/mounts");
        try {
            string = ServerSupportDataFsUtils.getNfsMountOptions(store, dir, reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | RuntimeException e) {
                return null;
            }
        }
        ((Reader)reader).close();
        return string;
    }

    @VisibleForTesting
    static String getNfsMountOptions(FileStore store, Path dir, Reader input) throws IOException {
        Map<String, String> mountToOptions = ServerSupportDataFsUtils.getMountsAndOptions(input);
        return ServerSupportDataFsUtils.getOptionsForMountPoint(dir, mountToOptions);
    }

    private static Map<String, String> getMountsAndOptions(Reader inputReader) throws IOException {
        HashMap<String, String> mountToOptions = new HashMap<String, String>();
        try (BufferedReader in = new BufferedReader(inputReader);){
            String line;
            while ((line = in.readLine()) != null) {
                String[] segments = line.split(" ");
                if (segments.length < 4) continue;
                mountToOptions.put(segments[1], segments[3]);
            }
        }
        return mountToOptions;
    }

    private static String getOptionsForMountPoint(Path dir, Map<String, String> mountToOptions) {
        String options = mountToOptions.get(dir.toAbsolutePath().toString());
        if (options == null) {
            Path possibleMount;
            for (possibleMount = dir.getParent(); possibleMount != null && !mountToOptions.containsKey(possibleMount.toAbsolutePath().toString()); possibleMount = possibleMount.getParent()) {
            }
            if (possibleMount != null) {
                options = mountToOptions.get(possibleMount.toAbsolutePath().toString());
            }
        }
        return options;
    }
}

