/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.api.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.api.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugins.shortcuts.api.KeyboardShortcutModuleDescriptor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiUsageAnalyticsHelper {
    private static final String ATLASSIAN_PLUGIN_PREFIX = "com.atlassian";
    private static final Set<String> WEB_RESOURCE_CONTEXT_PREFIXES = Sets.newHashSet((Object[])new String[]{"applinks.", "atl.", "bitbucket.", "internal."});
    private PluginAccessor pluginAccessor;

    @Autowired
    public ApiUsageAnalyticsHelper(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public ApiUsage getUsageForAllEnabledPlugins() {
        return this.pluginAccessor.getEnabledPlugins().stream().map(this::getUsageForPlugin).filter(Optional::isPresent).map(Optional::get).reduce(ApiUsage::union).orElse(ApiUsage.empty());
    }

    public Optional<ApiUsage> getUsageForPlugin(Plugin plugin) {
        if (plugin.getKey().startsWith(ATLASSIAN_PLUGIN_PREFIX)) {
            return Optional.empty();
        }
        ArrayList webItems = Lists.newArrayList();
        ArrayList webSections = Lists.newArrayList();
        ArrayList webPanels = Lists.newArrayList();
        ArrayList webResources = Lists.newArrayList();
        ArrayList keyboardShortcuts = Lists.newArrayList();
        for (ModuleDescriptor md : plugin.getModuleDescriptors()) {
            if (!md.isEnabled()) continue;
            if (md instanceof WebResourceModuleDescriptor) {
                webResources.add((WebResourceModuleDescriptor)md);
                continue;
            }
            if (md instanceof WebItemModuleDescriptor) {
                webItems.add((WebItemModuleDescriptor)md);
                continue;
            }
            if (md instanceof com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor) {
                webSections.add((com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor)md);
                continue;
            }
            if (md instanceof com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor) {
                webPanels.add((com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor)md);
                continue;
            }
            if (!(md instanceof KeyboardShortcutModuleDescriptor)) continue;
            keyboardShortcuts.add((KeyboardShortcutModuleDescriptor)md);
        }
        ArrayList allWebResources = Lists.newArrayList();
        allWebResources.addAll(webResources);
        Set<String> webItemLocations = this.normalize(webItems.stream().map(WebItemModuleDescriptor::getSection));
        Set<String> webSectionLocations = this.normalize(webSections.stream().map(WebSectionModuleDescriptor::getLocation));
        Set<String> webPanelLocations = this.normalize(webPanels.stream().map(WebPanelModuleDescriptor::getLocation));
        Set<String> keyboardShortcutContexts = this.normalize(keyboardShortcuts.stream().map(ks -> ks.getModule().getContext()));
        Set<String> webResourceDependencies = this.normalize(allWebResources.stream().flatMap(wr -> wr.getDependencies().stream()).filter(dep -> dep.startsWith(ATLASSIAN_PLUGIN_PREFIX)));
        Set<String> webResourceContexts = this.normalize(allWebResources.stream().flatMap(wr -> wr.getContexts().stream()).filter(context -> WEB_RESOURCE_CONTEXT_PREFIXES.stream().anyMatch(context::startsWith)));
        return Optional.of(new ApiUsage(webItemLocations, webSectionLocations, webPanelLocations, keyboardShortcutContexts, webResourceDependencies, webResourceContexts));
    }

    private Set<String> normalize(Stream<String> apiIdentifiers) {
        return apiIdentifiers.distinct().collect(Collectors.toSet());
    }

    public static class ApiUsage {
        private static ApiUsage EMPTY = new ApiUsage(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        private final Set<String> webItemLocations;
        private final Set<String> webSectionLocations;
        private final Set<String> webPanelLocations;
        private final Set<String> keyboardShortcutContexts;
        private final Set<String> webResourceDependencies;
        private final Set<String> webResourceContexts;

        private ApiUsage(Set<String> webItemLocations, Set<String> webSectionLocations, Set<String> webPanelLocations, Set<String> keyboardShortcutContexts, Set<String> webResourceDependencies, Set<String> webResourceContexts) {
            this.webItemLocations = webItemLocations;
            this.webSectionLocations = webSectionLocations;
            this.webPanelLocations = webPanelLocations;
            this.keyboardShortcutContexts = keyboardShortcutContexts;
            this.webResourceDependencies = webResourceDependencies;
            this.webResourceContexts = webResourceContexts;
        }

        public Set<String> getWebResourceContexts() {
            return this.webResourceContexts;
        }

        public Set<String> getWebResourceDependencies() {
            return this.webResourceDependencies;
        }

        public Set<String> getKeyboardShortcutContexts() {
            return this.keyboardShortcutContexts;
        }

        public Set<String> getWebPanelLocations() {
            return this.webPanelLocations;
        }

        public Set<String> getWebSectionLocations() {
            return this.webSectionLocations;
        }

        public Set<String> getWebItemLocations() {
            return this.webItemLocations;
        }

        public static ApiUsage union(ApiUsage a, ApiUsage b) {
            return new ApiUsage((Set<String>)Sets.union(a.getWebItemLocations(), b.getWebItemLocations()), (Set<String>)Sets.union(a.getWebSectionLocations(), b.getWebSectionLocations()), (Set<String>)Sets.union(a.getWebPanelLocations(), b.getWebPanelLocations()), (Set<String>)Sets.union(a.getKeyboardShortcutContexts(), b.getKeyboardShortcutContexts()), (Set<String>)Sets.union(a.getWebResourceDependencies(), b.getWebResourceDependencies()), (Set<String>)Sets.union(a.getWebResourceContexts(), b.getWebResourceContexts()));
        }

        public static ApiUsage empty() {
            return EMPTY;
        }

        public Map<String, Object> toMap() {
            return ImmutableMap.builder().put((Object)"webItem.locations", this.getWebItemLocations()).put((Object)"webSection.locations", this.getWebSectionLocations()).put((Object)"webPanel.locations", this.getWebPanelLocations()).put((Object)"keyboardShortcut.contexts", this.getKeyboardShortcutContexts()).put((Object)"webResource.dependencies", this.getWebResourceDependencies()).put((Object)"webResource.contexts", this.getWebResourceContexts()).build();
        }
    }
}

