/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.instance.attributes.config")
public class ConfigAttributesAnalyticsEvent
extends ApplicationEvent {
    private final Map<String, Object> database;
    private final Map<String, Object> features;
    private final Map<String, Object> jdbc;
    private final Map<String, Object> properties;
    private final Map<String, Object> usage;

    public ConfigAttributesAnalyticsEvent(@Nonnull Object source, @Nonnull Map<String, Object> database, @Nonnull Map<String, Object> jdbc, @Nonnull Map<String, Object> usage, @Nonnull Map<String, Object> features, @Nonnull Map<String, Object> properties) {
        super(source);
        this.database = Objects.requireNonNull(database, "database");
        this.features = Objects.requireNonNull(features, "features");
        this.jdbc = Objects.requireNonNull(jdbc, "jdbc");
        this.properties = Objects.requireNonNull(properties, "properties");
        this.usage = Objects.requireNonNull(usage, "usage");
    }

    @Nonnull
    public Map<String, Object> getDatabase() {
        return this.database;
    }

    @Nonnull
    public Map<String, Object> getFeatures() {
        return this.features;
    }

    @Nonnull
    public Map<String, Object> getJdbc() {
        return this.jdbc;
    }

    @Nonnull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Nonnull
    public Map<String, Object> getUsage() {
        return this.usage;
    }
}

