/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.stash.internal.server.analytics.AwsAnalytics;
import com.atlassian.stash.internal.server.analytics.AwsAnalyticsFactory;
import com.google.common.base.Function;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="awsAnalyticsFactory")
public class DefaultAwsAnalyticsFactory
implements AwsAnalyticsFactory {
    private static final Pattern AMI_REGEX_PATTERN = Pattern.compile("([^-]*-)([\\d\\w]+)");
    private static final String AWS_META_DATA_AMI_ID_PATH = "ami-id";
    private static final String AWS_META_DATA_INSTANCE_TYPE_PATH = "instance-type";
    private static final String AWS_META_DATA_URL = "http://169.254.169.254/latest/meta-data/";
    private static final int HTTP_REQUEST_TIMEOUT = 100;
    private static final Logger log = LoggerFactory.getLogger(DefaultAwsAnalyticsFactory.class);
    protected static final URI AWS_AMI_ID_URI = URI.create("http://169.254.169.254/latest/meta-data/ami-id");
    protected static final URI AWS_INSTANCE_TYPE_URI = URI.create("http://169.254.169.254/latest/meta-data/instance-type");
    private final HttpClient client;

    public DefaultAwsAnalyticsFactory() {
        this((HttpClient)HttpClientBuilder.create().build());
    }

    public DefaultAwsAnalyticsFactory(HttpClient client) {
        this.client = client;
    }

    @Override
    public Optional<AwsAnalytics> create() {
        return this.readAmiId().flatMap(new Function<String, Optional<AwsAnalytics>>(){

            public Optional<AwsAnalytics> apply(final String amiId) {
                return DefaultAwsAnalyticsFactory.this.readFromURI(AWS_INSTANCE_TYPE_URI).flatMap(new Function<String, Optional<AwsAnalytics>>(){

                    public Optional<AwsAnalytics> apply(String instanceType) {
                        return Optional.ofNullable(new AwsAnalytics.Builder(amiId, instanceType).build());
                    }
                });
            }
        });
    }

    private Optional<String> parseRawAmiId(String rawAmiId) {
        Matcher matcher;
        if (rawAmiId != null && (matcher = AMI_REGEX_PATTERN.matcher(rawAmiId)).matches()) {
            try {
                return Optional.ofNullable(matcher.group(1) + Long.parseLong(matcher.group(2), 16));
            }
            catch (NumberFormatException e) {
                log.info("Could not parse AMI ID for analytics. Raw AMI ID: {}", (Object)rawAmiId);
            }
        }
        return Optional.empty();
    }

    private Optional<String> readAmiId() {
        return this.readFromURI(AWS_AMI_ID_URI).flatMap(this::parseRawAmiId);
    }

    private Optional<String> readFromURI(URI uri) {
        try {
            HttpGet request = new HttpGet(uri);
            request.setConfig(RequestConfig.custom().setConnectTimeout(100).build());
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            return Optional.ofNullable(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }
}

