/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.stash.internal.server.analytics.AzureAnalyticsService;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service(value="azureAnalyticsService")
public class DefaultAzureAnalyticsService
implements AzureAnalyticsService {
    private static final String AZURE_VM_SIZE_URL = "http://169.254.169.254/metadata/instance/compute/vmSize?api-version=2018-04-02&format=text";
    private static final URI AZURE_VM_SIZE_URI = URI.create("http://169.254.169.254/metadata/instance/compute/vmSize?api-version=2018-04-02&format=text");
    private static final int HTTP_REQUEST_TIMEOUT = 100;
    private final HttpClient httpClient;

    public DefaultAzureAnalyticsService() {
        this((HttpClient)HttpClientBuilder.create().build());
    }

    public DefaultAzureAnalyticsService(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public boolean isOnAzure() {
        String vmSize = this.readFromURI(AZURE_VM_SIZE_URI);
        return StringUtils.isNotBlank((CharSequence)vmSize);
    }

    private String readFromURI(URI uri) {
        try {
            HttpGet request = new HttpGet(uri);
            request.setHeader("Metadata", "true");
            request.setConfig(RequestConfig.custom().setConnectTimeout(100).build());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

