/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.dmz.server.DmzDataStoreService;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.plugin.OptionalPluginInformationProvider;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.stash.internal.db.DatabaseSupplier;
import com.atlassian.stash.internal.db.DetailedDatabase;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.server.analytics.ApiUsageAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.ApiUsageAnalyticsHelper;
import com.atlassian.stash.internal.server.analytics.AwsAnalyticsFactory;
import com.atlassian.stash.internal.server.analytics.AwsAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.AzureAnalyticsService;
import com.atlassian.stash.internal.server.analytics.AzureAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.ConfigAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.JavaAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.MeshAttributesAnalyticsEvent;
import com.atlassian.stash.internal.server.analytics.SystemAttributesAnalyticsEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sun.management.OperatingSystemMXBean;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InstanceAnalyticsJob
implements ScheduledJobSource {
    private static final JobId INFORMATION_ANALYTICS_JOB_ID = JobId.of((String)InstanceAnalyticsJobRunner.class.getSimpleName());
    private static final JobRunnerKey INFORMATION_ANALYTICS_JOB_RUNNER_KEY = JobRunnerKey.of((String)InstanceAnalyticsJobRunner.class.getName());
    private static final Logger log = LoggerFactory.getLogger(InstanceAnalyticsJob.class);
    private final ApiUsageAnalyticsHelper apiUsageHelper;
    private final AwsAnalyticsFactory awsAnalyticsFactory;
    private final AzureAnalyticsService azureAnalyticsService;
    private final ClusterService clusterService;
    private final DatabaseSupplier databaseSupplier;
    private final DmzDataStoreService dataStoreService;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final LicenseService licenseService;
    private final DmzMeshService meshService;
    private final DmzMeshPartitionRegistry partitionRegistry;
    private final OptionalPluginInformationProvider pluginInformationProvider;
    private final InternalProjectService projectService;
    private final ApplicationPropertiesService propertiesService;
    private final InternalPullRequestService pullRequestService;
    private final InternalRepositoryService repositoryService;
    private final StorageService storageService;
    private final EscalatedSecurityContext withSysAdmin;
    @Value(value="${analytics.aws.enabled}")
    private boolean awsAnalyticsEnabled;
    private volatile boolean awsAnalyticsPublished;
    private volatile boolean azureAnalyticsPublished;
    @Value(value="${analytics.job.firstrun.minutes:30}")
    private long firstRunMinutes;
    @Value(value="${analytics.job.interval.minutes:1440}")
    private long intervalMinutes;

    @Autowired
    public InstanceAnalyticsJob(ApiUsageAnalyticsHelper apiUsageHelper, AwsAnalyticsFactory awsAnalyticsFactory, AzureAnalyticsService azureAnalyticsService, ClusterService clusterService, DatabaseSupplier databaseSupplier, DmzDataStoreService dataStoreService, EventPublisher eventPublisher, FeatureManager featureManager, LicenseService licenseService, DmzMeshService meshService, DmzMeshPartitionRegistry partitionRegistry, OptionalPluginInformationProvider pluginInformationProvider, InternalProjectService projectService, ApplicationPropertiesService propertiesService, InternalPullRequestService pullRequestService, InternalRepositoryService repositoryService, SecurityService securityService, StorageService storageService) {
        this.apiUsageHelper = apiUsageHelper;
        this.awsAnalyticsFactory = awsAnalyticsFactory;
        this.azureAnalyticsService = azureAnalyticsService;
        this.clusterService = clusterService;
        this.databaseSupplier = databaseSupplier;
        this.dataStoreService = dataStoreService;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.licenseService = licenseService;
        this.meshService = meshService;
        this.partitionRegistry = partitionRegistry;
        this.pluginInformationProvider = pluginInformationProvider;
        this.projectService = projectService;
        this.propertiesService = propertiesService;
        this.pullRequestService = pullRequestService;
        this.repositoryService = repositoryService;
        this.storageService = storageService;
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, this.getClass().getSimpleName());
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        long interval = TimeUnit.MINUTES.toMillis(this.intervalMinutes);
        long firstRun = TimeUnit.MINUTES.toMillis(this.firstRunMinutes);
        InstanceAnalyticsJobRunner jobRunner = new InstanceAnalyticsJobRunner();
        schedulerService.registerJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(INFORMATION_ANALYTICS_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)INFORMATION_ANALYTICS_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + firstRun))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(INFORMATION_ANALYTICS_JOB_ID);
        schedulerService.unregisterJobRunner(INFORMATION_ANALYTICS_JOB_RUNNER_KEY);
    }

    private ImmutableMap.Builder addPullRequestCount(ImmutableMap.Builder<String, Object> mapBuilder) {
        Map countsByState = this.pullRequestService.getCountsByState();
        return mapBuilder.put((Object)"pullRequests", (Object)new ImmutableMap.Builder().put((Object)"declined", countsByState.get(PullRequestState.DECLINED)).put((Object)"merged", countsByState.get(PullRequestState.MERGED)).put((Object)"open", countsByState.get(PullRequestState.OPEN)).build());
    }

    private ImmutableMap.Builder addDataStoreAnalytics(ImmutableMap.Builder<String, Object> mapBuilder, FileStore sharedFileStore) {
        List stores = (List)this.withSysAdmin.call(() -> this.dataStoreService.getConfig().getAdditional());
        if (stores.isEmpty()) {
            return mapBuilder;
        }
        HashSet<FileStore> countedFileStores = new HashSet<FileStore>();
        countedFileStores.add(sharedFileStore);
        ImmutableList.Builder dataStoreListBuilder = new ImmutableList.Builder();
        long summedTotalSpace = 0L;
        long summedFreeSpace = 0L;
        for (int i = 0; i < stores.size(); ++i) {
            long totalSpace = -1L;
            long freeSpace = -1L;
            int fileStoreHash = -1;
            try {
                FileStore fileStore = Files.getFileStore(((DataStore)stores.get(i)).getDir());
                totalSpace = fileStore.getTotalSpace();
                freeSpace = fileStore.getUsableSpace();
                fileStoreHash = fileStore.hashCode();
                if (countedFileStores.add(fileStore)) {
                    summedTotalSpace += totalSpace;
                    summedFreeSpace += freeSpace;
                }
            }
            catch (IOException e) {
                log.debug("Error gathering file store details for instance analytics", (Throwable)e);
            }
            if (i >= 5) continue;
            dataStoreListBuilder.add((Object)ImmutableMap.of((Object)"fileStoreHash", (Object)fileStoreHash, (Object)"freeDiskSpace", (Object)freeSpace, (Object)"totalDiskSpace", (Object)totalSpace));
        }
        return mapBuilder.put((Object)"dataStoreCount", (Object)stores.size()).put((Object)"totalDiskSpaceDataStores", (Object)summedTotalSpace).put((Object)"freeDiskSpaceDataStores", (Object)summedFreeSpace).put((Object)"dataStores", (Object)dataStoreListBuilder.build());
    }

    private Map<String, Object> getSystemInfo() {
        ImmutableMap.Builder systemInfoBuilder = new ImmutableMap.Builder();
        try {
            FileStore fileStore = Files.getFileStore(this.storageService.getHomeDir());
            FileStore sharedFileStore = Files.getFileStore(this.storageService.getSharedHomeDir());
            systemInfoBuilder.put((Object)"freeDiskSpaceHome", (Object)fileStore.getUsableSpace()).put((Object)"totalDiskSpaceHome", (Object)fileStore.getTotalSpace()).put((Object)"freeDiskSpaceSharedHome", (Object)sharedFileStore.getUsableSpace()).put((Object)"totalDiskSpaceSharedHome", (Object)sharedFileStore.getTotalSpace()).put((Object)"sharedHomeFileStoreHash", (Object)sharedFileStore.hashCode());
            this.addDataStoreAnalytics((ImmutableMap.Builder<String, Object>)systemInfoBuilder, sharedFileStore);
        }
        catch (IOException fileStore) {
            // empty catch block
        }
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            systemInfoBuilder.put((Object)"freePhysicalMemory", (Object)osBean.getFreePhysicalMemorySize()).put((Object)"totalPhysicalMemory", (Object)osBean.getTotalPhysicalMemorySize());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return systemInfoBuilder.build();
    }

    private void publishAnalyticsEvent() {
        Runtime rt = Runtime.getRuntime();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        ImmutableMap jre = ImmutableMap.of((Object)"vendor", (Object)System.getProperty("java.vendor"), (Object)"version", (Object)System.getProperty("java.version"), (Object)"vm.name", (Object)System.getProperty("java.vm.name"), (Object)"vm.arch", (Object)System.getProperty("sun.arch.data.model"));
        ImmutableMap jvm = ImmutableMap.of((Object)"availableProcessors", (Object)rt.availableProcessors(), (Object)"freeMemory", (Object)rt.freeMemory(), (Object)"maxMemory", (Object)rt.maxMemory(), (Object)"totalMemory", (Object)rt.totalMemory(), (Object)"uptime", (Object)runtimeMXBean.getUptime());
        ImmutableMap os = ImmutableMap.of((Object)"arch", (Object)System.getProperty("os.arch"), (Object)"name", (Object)System.getProperty("os.name"), (Object)"version", (Object)System.getProperty("os.version"));
        Map<String, Object> system = this.getSystemInfo();
        DetailedDatabase db = this.databaseSupplier.get();
        ImmutableMap database = ImmutableMap.of((Object)"aurora", (Object)db.isAurora(), (Object)"name", (Object)db.getName(), (Object)"version", (Object)db.getVersion().toString());
        ImmutableMap.Builder propertiesBuilder = new ImmutableMap.Builder().put((Object)"security", (Object)new ImmutableMap.Builder().put((Object)"secretStore.type", (Object)SecretService.class.getName()).build());
        ImmutableMap properties = propertiesBuilder.build();
        ImmutableMap jdbc = ImmutableMap.of((Object)"driver", (Object)this.propertiesService.getJdbcDriver(), (Object)"version", (Object)this.propertiesService.getJdbcDriverVersion());
        int maxNumberOfUsers = -1;
        BitbucketServerLicense license = this.licenseService.get();
        if (license != null) {
            maxNumberOfUsers = license.getMaximumNumberOfUsers();
        }
        ImmutableMap.Builder usageBuilder = new ImmutableMap.Builder().put((Object)"applicationMode", (Object)this.propertiesService.getMode()).put((Object)"licensedUsers", (Object)this.licenseService.getLicensedUsersCount()).put((Object)"maxLicensedUsers", (Object)maxNumberOfUsers).put((Object)"projectCount", (Object)this.projectService.getCount()).put((Object)"repositoryCount", (Object)this.repositoryService.getCount()).put((Object)"clusterSize", (Object)this.clusterService.getInformation().getNodes().size());
        this.addPullRequestCount((ImmutableMap.Builder<String, Object>)usageBuilder);
        ImmutableMap.Builder featureBuilder = new ImmutableMap.Builder();
        for (StandardFeature feature : StandardFeature.values()) {
            featureBuilder.put((Object)feature.getKey(), (Object)ImmutableMap.of((Object)"available", (Object)true, (Object)"enabled", (Object)this.featureManager.isEnabled((Feature)feature)));
        }
        ImmutableMap usage = usageBuilder.build();
        if (this.awsAnalyticsEnabled && !this.awsAnalyticsPublished) {
            this.awsAnalyticsFactory.create().ifPresent(awsAnalytics -> this.eventPublisher.publish((Object)new AwsAttributesAnalyticsEvent(this, awsAnalytics.getAmiId(), awsAnalytics.getInstanceType())));
            this.awsAnalyticsPublished = true;
        }
        if (!this.azureAnalyticsPublished && this.azureAnalyticsService.isOnAzure()) {
            this.eventPublisher.publish((Object)new AzureAttributesAnalyticsEvent(this));
            this.azureAnalyticsPublished = true;
        }
        this.eventPublisher.publish((Object)new JavaAttributesAnalyticsEvent(this, (Map<String, Object>)jre, (Map<String, Object>)jvm));
        this.eventPublisher.publish((Object)new SystemAttributesAnalyticsEvent(this, (Map<String, Object>)os, system));
        this.eventPublisher.publish((Object)new ConfigAttributesAnalyticsEvent(this, (Map<String, Object>)database, (Map<String, Object>)jdbc, (Map<String, Object>)usage, (Map<String, Object>)featureBuilder.build(), (Map<String, Object>)properties));
        this.eventPublisher.publish((Object)new ApiUsageAnalyticsEvent(this, this.apiUsageHelper.getUsageForAllEnabledPlugins()));
        if (this.meshService != null) {
            try {
                MeshAttributesAnalyticsEvent event = (MeshAttributesAnalyticsEvent)((Object)this.withSysAdmin.call(() -> {
                    long remoteNodeCount = this.meshService.getMembers().stream().filter(node -> !node.isSidecar()).count();
                    int partitionCount = this.partitionRegistry.size();
                    return new MeshAttributesAnalyticsEvent(this, partitionCount, remoteNodeCount, this.meshService.getReplicationFactor());
                }));
                this.eventPublisher.publish((Object)event);
            }
            catch (Exception e) {
                log.debug("Error gathering Mesh details for instance analytics", (Throwable)e);
            }
        }
    }

    private class InstanceAnalyticsJobRunner
    implements JobRunner {
        private InstanceAnalyticsJobRunner() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            if (InstanceAnalyticsJob.this.pluginInformationProvider.canCollectAnalytics()) {
                InstanceAnalyticsJob.this.publishAnalyticsEvent();
            }
            return JobRunnerResponse.success();
        }
    }
}

