/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.analytics.api.events.MauEvent;
import com.atlassian.bitbucket.dmz.request.DmzRequestContext;
import com.atlassian.bitbucket.event.request.RequestEndedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MauEventPublisher {
    private final EventPublisher eventPublisher;
    private final long eventPublishInterval;
    private final ConcurrentMap<String, Long> lastSentCache;

    @Autowired
    public MauEventPublisher(EventPublisher eventPublisher, @Value(value="${analytics.mauevent.publish.interval}") int eventPublishIntervalInMinutes) {
        this(eventPublisher, eventPublishIntervalInMinutes, new ConcurrentHashMap());
    }

    @VisibleForTesting
    MauEventPublisher(EventPublisher eventPublisher, @Value(value="${analytics.mauevent.publish.interval}") int eventPublishIntervalInMinutes, ConcurrentMap lastSentCache) {
        this.eventPublisher = eventPublisher;
        this.eventPublishInterval = TimeUnit.MINUTES.toMillis(eventPublishIntervalInMinutes);
        this.lastSentCache = lastSentCache;
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent event) {
        DmzRequestContext requestContext = (DmzRequestContext)event.getRequestContext();
        requestContext.getAuthenticatedUser().ifPresent(user -> {
            String emailAddress = user.getEmailAddress();
            if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                Long lastSentTime = Optional.ofNullable((Long)this.lastSentCache.get(emailAddress)).orElse(0L);
                long currentTime = System.currentTimeMillis();
                if (currentTime > lastSentTime + this.eventPublishInterval) {
                    this.eventPublisher.publish((Object)MauEvent.withEmail((String)emailAddress));
                    this.lastSentCache.put(emailAddress, currentTime);
                }
            }
        });
    }
}

