/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.analytics;

import com.atlassian.bitbucket.dmz.user.DmzPermissionAdminService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.plugin.OptionalPluginInformationProvider;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.server.analytics.ProjectPermissionAnalyticsEvent;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DefaultApplicationMode
public class ProjectPermissionAnalyticsJob
implements ScheduledJobSource {
    private static final JobId PROJECT_PERMISSION_ANALYTICS_JOB_ID = JobId.of((String)ProjectPermissionAnalyticsJobRunner.class.getSimpleName());
    private static final JobRunnerKey PROJECT_PERMISSION_ANALYTICS_JOB_RUNNER_KEY = JobRunnerKey.of((String)ProjectPermissionAnalyticsJobRunner.class.getName());
    private final EventPublisher eventPublisher;
    private final DmzPermissionAdminService permissionAdminService;
    private final OptionalPluginInformationProvider pluginInformationProvider;
    private final EscalatedSecurityContext withSysAdmin;

    @Autowired
    public ProjectPermissionAnalyticsJob(EventPublisher eventPublisher, DmzPermissionAdminService permissionAdminService, OptionalPluginInformationProvider pluginInformationProvider, SecurityService securityService) {
        this.eventPublisher = eventPublisher;
        this.permissionAdminService = permissionAdminService;
        this.pluginInformationProvider = pluginInformationProvider;
        this.withSysAdmin = securityService.withPermission(Permission.ADMIN, this.getClass().getSimpleName());
    }

    public void schedule(@Nonnull SchedulerService schedulerService) throws SchedulerServiceException {
        long interval = TimeUnit.DAYS.toMillis(1L);
        long firstRun = TimeUnit.MINUTES.toMillis(30L);
        ProjectPermissionAnalyticsJobRunner jobRunner = new ProjectPermissionAnalyticsJobRunner();
        schedulerService.registerJobRunner(PROJECT_PERMISSION_ANALYTICS_JOB_RUNNER_KEY, (JobRunner)jobRunner);
        schedulerService.scheduleJob(PROJECT_PERMISSION_ANALYTICS_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)PROJECT_PERMISSION_ANALYTICS_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + firstRun))));
    }

    public void unschedule(@Nonnull SchedulerService schedulerService) {
        schedulerService.unscheduleJob(PROJECT_PERMISSION_ANALYTICS_JOB_ID);
        schedulerService.unregisterJobRunner(PROJECT_PERMISSION_ANALYTICS_JOB_RUNNER_KEY);
    }

    private void publishAnalyticsEvent() {
        Map countsByGroups = (Map)this.withSysAdmin.call(() -> this.permissionAdminService.countByPermissionForAllGroups());
        Map countsByUsers = (Map)this.withSysAdmin.call(() -> this.permissionAdminService.countByPermissionForAllUsers());
        this.eventPublisher.publish((Object)new ProjectPermissionAnalyticsEvent(this, countsByGroups, countsByUsers));
    }

    private class ProjectPermissionAnalyticsJobRunner
    implements JobRunner {
        private ProjectPermissionAnalyticsJobRunner() {
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
            if (ProjectPermissionAnalyticsJob.this.pluginInformationProvider.canCollectAnalytics()) {
                ProjectPermissionAnalyticsJob.this.publishAnalyticsEvent();
            }
            return JobRunnerResponse.success();
        }
    }
}

