/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.upgrade;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.secrets.DmzSecretService;
import com.atlassian.bitbucket.dmz.secrets.SecretNamespace;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.upgrade.ApplicationSecretUpgradeTask;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationSecretUpgradeTask
implements ApplicationSecretUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractApplicationSecretUpgradeTask.class);
    private final HomeLayout homeLayout;
    private final LockService lockService;
    private final ApplicationPropertyDao propertyDao;
    private final DmzSecretService secretService;

    protected AbstractApplicationSecretUpgradeTask(HomeLayout homeLayout, LockService lockService, ApplicationPropertyDao propertyDao, DmzSecretService secretService) {
        this.homeLayout = homeLayout;
        this.lockService = lockService;
        this.propertyDao = propertyDao;
        this.secretService = secretService;
    }

    @Override
    public void apply() {
        if (!this.getApplicationPropertyKey().isSecret()) {
            throw new IllegalStateException(String.format("Application property %s is not a secret", this.getApplicationPropertyKey()));
        }
        Path markerFile = this.homeLayout.getUpgradesDir().resolve(this.getKeyTask());
        if (this.isUpgradeComplete(markerFile)) {
            return;
        }
        try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(this.getKeyTaskLock()));){
            log.debug("Locked upgrade task {}", (Object)this.getKeyTaskLock());
            if (this.isUpgradeComplete(markerFile)) {
                return;
            }
            this.doUpgrade();
            MoreFiles.mkdir((Path)markerFile.getParent());
            MoreFiles.touch((Path)markerFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        log.debug("Released upgrade task lock {}", (Object)this.getKeyTaskLock());
    }

    @Nonnull
    protected abstract ApplicationProperty.Key getApplicationPropertyKey();

    @Nonnull
    protected abstract String getKeyTask();

    @Nonnull
    protected abstract String getKeyTaskLock();

    private void doUpgrade() {
        log.info("Starting upgrade task {}", (Object)this.getKeyTask());
        ApplicationProperty property = this.propertyDao.getById(this.getApplicationPropertyKey());
        if (property == null) {
            this.propertyDao.create(new ApplicationProperty(this.getApplicationPropertyKey(), "{ATL_SECURED}"));
        } else {
            if (StringUtils.isNotBlank((CharSequence)property.getValue())) {
                this.secretService.put(SecretNamespace.INTERNAL, this.getApplicationPropertyKey().getId(), property.getValue());
            }
            this.propertyDao.update(new ApplicationProperty(this.getApplicationPropertyKey(), "{ATL_SECURED}"));
        }
        log.info("Upgrade task {} completed", (Object)this.getKeyTask());
    }

    private boolean isUpgradeComplete(Path markerFile) {
        if (Files.exists(markerFile, new LinkOption[0])) {
            log.debug("Upgrade task already previously completed {}", (Object)this.getKeyTask());
            return true;
        }
        return false;
    }
}

