/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server.upgrade;

import com.atlassian.bitbucket.dmz.secrets.SecretServiceConfig;
import com.atlassian.stash.internal.server.upgrade.ApplicationSecretUpgradeTask;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="applicationSecretsUpgradeTaskRunner")
public class ApplicationSecretsUpgradeTaskRunner {
    private static final Logger log = LoggerFactory.getLogger(ApplicationSecretsUpgradeTaskRunner.class);
    private final SecretServiceConfig secretServiceConfig;
    private final List<ApplicationSecretUpgradeTask> upgradeTasks;

    @Autowired
    public ApplicationSecretsUpgradeTaskRunner(SecretServiceConfig secretServiceConfig, List<ApplicationSecretUpgradeTask> upgradeTasks) {
        this.secretServiceConfig = secretServiceConfig;
        this.upgradeTasks = upgradeTasks;
    }

    @PostConstruct
    public void runTasks() {
        if (this.secretServiceConfig.isDisabled()) {
            log.debug("Skipping application secrets upgrade tasks because secret service is disabled");
            return;
        }
        for (ApplicationSecretUpgradeTask upgradeTask : this.upgradeTasks) {
            upgradeTask.apply();
        }
    }
}

