/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.setting;

import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.validation.FormValidationException;
import com.atlassian.stash.internal.setting.DeserializeSettingsException;
import com.atlassian.stash.internal.setting.MapSettingsBuilder;
import com.atlassian.stash.internal.setting.SerializeSettingsException;
import com.atlassian.stash.internal.setting.SettingsHelper;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component(value="settingsHelper")
public class JacksonSettingsHelper
implements SettingsHelper {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Nonnull
    public Settings deserialize(@Nonnull String data) {
        Objects.requireNonNull(data, "data");
        try {
            return new MapSettingsBuilder().addAll((Map)MAPPER.readValue(data, Map.class)).build();
        }
        catch (IOException e) {
            throw new DeserializeSettingsException("The provided data could not be deserialized from JSON", (Throwable)e);
        }
    }

    @Nonnull
    public String serialize(@Nonnull Settings settings) throws FormValidationException {
        Objects.requireNonNull(settings, "settings");
        try {
            return MAPPER.writeValueAsString((Object)settings.asMap());
        }
        catch (IOException e) {
            throw new SerializeSettingsException("The provided Settings could not be serialized to JSON", (Throwable)e);
        }
    }
}

