/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction;

import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.settingsrestriction.InternalProjectSettingsRestrictionService;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingHelper;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingManager;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingManagerFactory;
import com.atlassian.stash.internal.settingsrestriction.config.RestrictionProcessingConfigProvider;
import com.atlassian.stash.internal.settingsrestriction.event.ProjectSettingsRestrictionProcessRepositoryEvent;
import com.atlassian.stash.internal.settingsrestriction.event.SettingsRestrictionProcessingFailedEvent;
import com.atlassian.stash.internal.settingsrestriction.result.RestrictionProcessingResult;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectSettingsRestrictionProcessingHelper")
@Profiled
public class DefaultProjectSettingsRestrictionProcessingHelper
implements ProjectSettingsRestrictionProcessingHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectSettingsRestrictionProcessingHelper.class);
    private final RestrictionProcessingConfigProvider configProvider;
    private final EventPublisher eventPublisher;
    private final ProjectSettingsRestrictionProcessingManagerFactory managerFactory;
    private final InternalProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    @Autowired
    public DefaultProjectSettingsRestrictionProcessingHelper(RestrictionProcessingConfigProvider configProvider, EventPublisher eventPublisher, ProjectSettingsRestrictionProcessingManagerFactory managerFactory, InternalProjectSettingsRestrictionService projectSettingsRestrictionService, RepositoryService repositoryService, SecurityService securityService) {
        this.configProvider = configProvider;
        this.eventPublisher = eventPublisher;
        this.managerFactory = managerFactory;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    @Override
    @Nonnull
    public Collection<RestrictionProcessingResult> process(@Nonnull Collection<DmzProjectSettingsRestriction> restrictions) {
        Objects.requireNonNull(restrictions, "restrictions");
        HashMap<Project, List> partitionedManagers = new HashMap<Project, List>();
        ImmutableList.Builder processingResults = ImmutableList.builder();
        for (DmzProjectSettingsRestriction restriction : restrictions) {
            ProjectSettingsRestrictionProcessingManager manager = this.managerFactory.create(restriction);
            if (!manager.hasProcessors()) {
                log.debug("No processors configured for {}; marking restriction of {} as processed", (Object)restriction.getSettingsKey(), (Object)restriction.getProject());
                this.projectSettingsRestrictionService.setProcessedState(restriction.getProject(), restriction.getSettingsKey(), RestrictionProcessedState.PROCESSED);
                processingResults.add((Object)new RestrictionProcessingResult.Builder(restriction).restrictionProcessed(true).build());
                continue;
            }
            log.debug("Processor(s) configured for {}", (Object)restriction.getSettingsKey());
            partitionedManagers.computeIfAbsent(restriction.getProject(), project -> new ArrayList()).add(manager);
            this.projectSettingsRestrictionService.setProcessedState(restriction.getProject(), restriction.getSettingsKey(), RestrictionProcessedState.IN_PROGRESS);
        }
        for (Project project2 : partitionedManagers.keySet()) {
            Collection<RestrictionProcessingResult> results = this.processAllRestrictions(project2, (List)partitionedManagers.get(project2));
            for (RestrictionProcessingResult projectProcessingResult : results) {
                DmzProjectSettingsRestriction restriction = projectProcessingResult.getRestriction();
                if (projectProcessingResult.isRestrictionProcessed()) {
                    this.projectSettingsRestrictionService.setProcessedState(restriction.getProject(), restriction.getSettingsKey(), RestrictionProcessedState.PROCESSED);
                    continue;
                }
                if (projectProcessingResult.getRestriction().getProcessingAttempts() >= this.configProvider.getMaxRetryCount()) {
                    this.projectSettingsRestrictionService.setProcessedState(restriction.getProject(), restriction.getSettingsKey(), RestrictionProcessedState.FAILED);
                    continue;
                }
                this.projectSettingsRestrictionService.setProcessedState(restriction.getProject(), restriction.getSettingsKey(), RestrictionProcessedState.UNPROCESSED);
                this.eventPublisher.publish((Object)new SettingsRestrictionProcessingFailedEvent(this, restriction));
            }
            processingResults.addAll(results);
        }
        return processingResults.build();
    }

    @Override
    @Nonnull
    public Collection<RestrictionProcessingResult> processRepository(@Nonnull Repository repository) {
        Set<DmzProjectSettingsRestriction> restrictions = this.projectSettingsRestrictionService.getAllByProject(repository.getProject());
        Set<Repository> processRequest = Collections.singleton(repository);
        ImmutableList.Builder results = ImmutableList.builder();
        for (DmzProjectSettingsRestriction restriction : restrictions) {
            results.add((Object)this.managerFactory.create(restriction).process(processRequest));
            this.eventPublisher.publish((Object)new ProjectSettingsRestrictionProcessRepositoryEvent((Object)this, repository, restriction));
        }
        return results.build();
    }

    private Collection<RestrictionProcessingResult> processAllRestrictions(final Project project, List<ProjectSettingsRestrictionProcessingManager> managers) {
        Page nextPage;
        PageProvider<Repository> pageProvider = new PageProvider<Repository>(){

            @Nonnull
            public Page<Repository> get(@Nonnull PageRequest pageRequest) {
                return (Page)DefaultProjectSettingsRestrictionProcessingHelper.this.securityService.withPermission(Permission.PROJECT_READ, "Process all repositories affected by project settings restrictions").call(() -> DefaultProjectSettingsRestrictionProcessingHelper.this.repositoryService.findByProjectKey(project.getKey(), pageRequest));
            }
        };
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.configProvider.getRepositoryBatchSize());
        HashMap<ProjectSettingsRestrictionProcessingManager, RestrictionProcessingResult> processingResults = new HashMap<ProjectSettingsRestrictionProcessingManager, RestrictionProcessingResult>();
        do {
            nextPage = pageProvider.get(Objects.requireNonNull(pageRequest, "pageRequest"));
            for (ProjectSettingsRestrictionProcessingManager manager : managers) {
                processingResults.put(manager, manager.process((Set)nextPage.stream().collect(MoreCollectors.toImmutableSet())));
            }
            processingResults.entrySet().stream().filter(entry -> !((RestrictionProcessingResult)entry.getValue()).isRestrictionProcessed()).forEach(failingEntries -> managers.remove(failingEntries.getKey()));
            if (managers.isEmpty()) break;
            pageRequest = nextPage.getNextPageRequest();
        } while (!nextPage.getIsLastPage());
        return processingResults.values();
    }
}

