/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionSearchRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionAction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionCreateRequest;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionService;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.settingsrestriction.UnprocessedProjectSettingsRestrictionException;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.settingsrestriction.InternalProjectSettingsRestriction;
import com.atlassian.stash.internal.settingsrestriction.InternalProjectSettingsRestrictionService;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionDao;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingManagerFactory;
import com.atlassian.stash.internal.settingsrestriction.config.RestrictionProcessingConfigProvider;
import com.atlassian.stash.internal.settingsrestriction.event.ProjectSettingsRestrictionCreatedEvent;
import com.atlassian.stash.internal.settingsrestriction.event.ProjectSettingsRestrictionDeletedEvent;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={ProjectSettingsRestrictionService.class, DmzProjectSettingsRestrictionService.class})
@Service(value="projectSettingsRestrictionService")
public class DefaultProjectSettingsRestrictionService
implements InternalProjectSettingsRestrictionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectSettingsRestrictionService.class);
    private final RestrictionProcessingConfigProvider configProvider;
    private final ProjectSettingsRestrictionDao dao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ProjectSettingsRestrictionProcessingManagerFactory managerFactory;
    private final PermissionService permissionService;

    @Autowired
    public DefaultProjectSettingsRestrictionService(RestrictionProcessingConfigProvider configProvider, ProjectSettingsRestrictionDao dao, EventPublisher eventPublisher, I18nService i18nService, ProjectSettingsRestrictionProcessingManagerFactory managerFactory, PermissionService permissionService) {
        this.configProvider = configProvider;
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.managerFactory = managerFactory;
        this.permissionService = permissionService;
    }

    @Nonnull
    @RequireFeature(value=StandardFeature.ENFORCE_PROJECT_SETTINGS)
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN')")
    @Transactional
    public ProjectSettingsRestriction create(@Nonnull ProjectSettingsRestrictionCreateRequest request) {
        Objects.requireNonNull(request, "request");
        if (this.dao.getByProjectAndSettingsKey(request.getProject(), request.getSettingsKey()).isPresent()) {
            throw new IntegrityException(this.i18nService.createKeyedMessage("bitbucket.service.settingsrestriction.error.create.duplicate", new Object[0]));
        }
        boolean hasProcessors = this.managerFactory.hasProcessors(request.getSettingsKey());
        InternalProjectSettingsRestriction.Builder builder = new InternalProjectSettingsRestriction.Builder(request);
        if (!hasProcessors) {
            builder.processedState(RestrictionProcessedState.PROCESSED);
        }
        InternalProjectSettingsRestriction restriction = (InternalProjectSettingsRestriction)this.dao.create((Object)builder.build());
        this.eventPublisher.publish((Object)new ProjectSettingsRestrictionCreatedEvent((Object)this, hasProcessors, (DmzProjectSettingsRestriction)restriction));
        return restriction;
    }

    @RequireFeature(value=StandardFeature.ENFORCE_PROJECT_SETTINGS)
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    @Transactional
    public void delete(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(settingsKey, "settingsKey");
        this.validateNotPersonalProject(project);
        this.dao.getByProjectAndSettingsKey(project, settingsKey).ifPresent(restriction -> {
            if (RestrictionProcessedState.getFinishedStates().contains(restriction.getProcessedState())) {
                if (this.dao.deleteByProjectAndSettingsKey(project, settingsKey)) {
                    this.eventPublisher.publish((Object)new ProjectSettingsRestrictionDeletedEvent(this, (DmzProjectSettingsRestriction)restriction));
                }
                return;
            }
            throw new UnprocessedProjectSettingsRestrictionException(this.i18nService.createKeyedMessage("bitbucket.service.settingsrestriction.error.delete.unprocessed.restriction", new Object[0]), (ProjectSettingsRestriction)restriction);
        });
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_VIEW')")
    @Transactional(readOnly=true)
    public Optional<ProjectSettingsRestriction> get(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(settingsKey, "settingsKey");
        if (project.getType() == ProjectType.PERSONAL) {
            return Optional.empty();
        }
        return this.dao.getByProjectAndSettingsKey(project, settingsKey).map(ProjectSettingsRestriction.class::cast);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_VIEW')")
    @Transactional(readOnly=true)
    public Set<ProjectSettingsRestriction> getAll(@Nonnull Project project, @Nonnull String namespace, @Nonnull String featureKey) {
        return this.doGetAll(project, namespace, featureKey);
    }

    @Override
    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_VIEW')")
    @Transactional(readOnly=true)
    public Set<DmzProjectSettingsRestriction> getAllByProject(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        if (project.getType() == ProjectType.PERSONAL) {
            return Collections.emptySet();
        }
        return ImmutableSet.copyOf((Collection)this.dao.getAllByProject(project));
    }

    @Nonnull
    @Transactional(readOnly=true)
    @Unsecured(value="Free for plugins to call and not exposed otherwise")
    public Set<ProjectSettingsRestriction> getAllUnsecured(@Nonnull Project project, @Nonnull String namespace, @Nonnull String featureKey) {
        return this.doGetAll(project, namespace, featureKey);
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional(readOnly=true)
    public Set<Integer> getRestrictedProjects(@Nonnull Collection<Project> projects, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(projects, "projects");
        Objects.requireNonNull(settingsKey, "settingsKey");
        if (projects.isEmpty()) {
            return Collections.emptySet();
        }
        this.validateHasProjectView(projects);
        return this.dao.getRestrictedProjects(DefaultProjectSettingsRestrictionService.mapProjectToIds(projects), settingsKey);
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_VIEW')")
    @Transactional(readOnly=true)
    public boolean hasRestriction(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
        return this.doHasRestriction(project, settingsKey);
    }

    @Transactional(readOnly=true)
    @Unsecured(value="Free for plugins to call and not exposed otherwise")
    public boolean hasRestrictionUnsecured(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
        return this.doHasRestriction(project, settingsKey);
    }

    @Secured(value="Permission check performed internally")
    @Transactional(readOnly=true)
    public boolean hasRestrictions(@Nonnull Collection<Project> projects, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(projects, "projects");
        Objects.requireNonNull(settingsKey, "settingsKey");
        this.validateHasProjectView(projects);
        if (projects.isEmpty()) {
            return false;
        }
        return this.dao.hasRestrictions(DefaultProjectSettingsRestrictionService.mapProjectToIds(projects), settingsKey);
    }

    @Override
    @Transactional
    @Unsecured(value="This is an internal service method")
    public int resetExpiredInProgress(@Nonnull Instant now) {
        Objects.requireNonNull(now, "now");
        Instant processingStartedOnOrBefore = now.minus(this.configProvider.getInProgressExpiryTime());
        return this.dao.resetExpiredInProgress(processingStartedOnOrBefore);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional(readOnly=true)
    public Page<DmzProjectSettingsRestriction> search(@Nonnull ProjectSettingsRestrictionSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest");
        Objects.requireNonNull(pageRequest, "pageRequest");
        return PageUtils.asPageOf(DmzProjectSettingsRestriction.class, (Page)this.dao.search(searchRequest, pageRequest));
    }

    @Override
    @Transactional
    @Unsecured(value="This is an internal service method")
    public void setProcessedState(@Nonnull Project project, @Nonnull SettingsKey settingsKey, @Nonnull RestrictionProcessedState processedState) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(settingsKey, "settingsKey");
        Objects.requireNonNull(processedState, "processedState");
        boolean updateSuccessful = this.dao.setProcessedState(project, settingsKey, processedState);
        if (!updateSuccessful) {
            log.warn("Marking settings restriction with project '{}' and settings key '{}' as '{}' failed", new Object[]{project, settingsKey, processedState});
        }
    }

    @Nonnull
    @Secured(value="Permission check performed internally")
    @Transactional
    public <T> T withRestriction(@Nonnull Project project, @Nonnull SettingsKey settingsKey, @Nonnull ProjectSettingsRestrictionAction action, @Nonnull Supplier<T> operation) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(settingsKey, "settingsKey");
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(operation, "operation");
        if (action == ProjectSettingsRestrictionAction.NONE) {
            return operation.get();
        }
        boolean isAlreadyRestricted = this.hasRestriction(project, settingsKey);
        if (!isAlreadyRestricted && action == ProjectSettingsRestrictionAction.CREATE) {
            log.debug("Creating new restriction for {} {}", (Object)project, (Object)settingsKey);
            this.create(new ProjectSettingsRestrictionCreateRequest.Builder(project, settingsKey).build());
        } else if (isAlreadyRestricted && action == ProjectSettingsRestrictionAction.DELETE) {
            log.debug("Deleting existing restriction for {} {}", (Object)project, (Object)settingsKey);
            this.delete(project, settingsKey);
        }
        return operation.get();
    }

    private static Set<Integer> mapProjectToIds(@Nonnull Collection<Project> projects) {
        return (Set)projects.stream().map(Project::getId).collect(MoreCollectors.toImmutableSet());
    }

    private Set<ProjectSettingsRestriction> doGetAll(@Nonnull Project project, @Nonnull String namespace, @Nonnull String featureKey) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(namespace, "namespace");
        Objects.requireNonNull(featureKey, "featureKey");
        if (project.getType() == ProjectType.PERSONAL) {
            return Collections.emptySet();
        }
        return (Set)this.dao.getAllByProjectNamespaceAndFeatureKey(project, namespace, featureKey).stream().map(ProjectSettingsRestriction.class::cast).collect(MoreCollectors.toImmutableSet());
    }

    private boolean doHasRestriction(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(project, "project");
        Objects.requireNonNull(settingsKey, "settingsKey");
        if (project.getType() == ProjectType.PERSONAL) {
            return false;
        }
        return this.dao.hasRestrictions(DefaultProjectSettingsRestrictionService.mapProjectToIds(Collections.singleton(project)), settingsKey);
    }

    private void validateHasProjectView(@Nonnull Collection<Project> projects) {
        if (projects.stream().anyMatch(project -> !this.permissionService.hasProjectPermission(project, Permission.PROJECT_VIEW))) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.service.settingsrestriction.accessdenied", new Object[0]));
        }
    }

    private void validateNotPersonalProject(Project project) {
        if (project.getType() == ProjectType.PERSONAL) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.service.settingsrestriction.personalproject.blocked", new Object[0]));
        }
    }
}

