/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction;

import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionDao;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingHelper;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingRequest;
import com.atlassian.stash.internal.settingsrestriction.RestrictionProcessingBucketProcessor;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="restrictionProcessingBucketProcessor")
public class DefaultRestrictionProcessingBucketProcessor
implements RestrictionProcessingBucketProcessor {
    private static final Logger log = LoggerFactory.getLogger(RestrictionProcessingBucketProcessor.class);
    private final ProjectSettingsRestrictionProcessingHelper processingHelper;
    private final TransactionTemplate readOnlyTransaction;
    private final ProjectSettingsRestrictionDao restrictionDao;

    @Autowired
    public DefaultRestrictionProcessingBucketProcessor(ProjectSettingsRestrictionProcessingHelper processingHelper, ProjectSettingsRestrictionDao restrictionDao, PlatformTransactionManager transactionManager) {
        this.processingHelper = processingHelper;
        this.restrictionDao = restrictionDao;
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)3, (boolean)true));
    }

    public void process(@Nonnull String bucketId, @Nonnull List<ProjectSettingsRestrictionProcessingRequest> requests) {
        Objects.requireNonNull(bucketId, "bucketId");
        Objects.requireNonNull(requests, "requests");
        Set restrictionIds = (Set)requests.stream().map(ProjectSettingsRestrictionProcessingRequest::getRestrictionId).collect(MoreCollectors.toImmutableSet());
        List restrictions = (List)this.readOnlyTransaction.execute(status -> (List)this.restrictionDao.getByIds((Collection)restrictionIds).stream().filter(restriction -> restriction.getProcessedState() == RestrictionProcessedState.UNPROCESSED).collect(MoreCollectors.toImmutableList()));
        if (restrictions.isEmpty()) {
            log.debug("No restrictions found for requests {}", requests);
            return;
        }
        this.processingHelper.process(restrictions);
    }
}

