/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction;

import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessor;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessingRequest;
import com.atlassian.stash.internal.settingsrestriction.result.ProcessorInfo;
import com.atlassian.stash.internal.settingsrestriction.result.ProcessorState;
import com.atlassian.stash.internal.settingsrestriction.result.RestrictionProcessingResult;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectSettingsRestrictionProcessingManager {
    private static final Logger log = LoggerFactory.getLogger(ProjectSettingsRestrictionProcessingManager.class);
    private final List<ProjectSettingsRestrictionProcessor> processors;
    private final DmzProjectSettingsRestriction restriction;

    public ProjectSettingsRestrictionProcessingManager(@Nonnull DmzProjectSettingsRestriction restriction, @Nonnull List<ProjectSettingsRestrictionProcessor> processors) {
        this.restriction = Objects.requireNonNull(restriction, "restriction");
        this.processors = Objects.requireNonNull(processors, "processors");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSettingsRestrictionProcessingManager manager = (ProjectSettingsRestrictionProcessingManager)o;
        return this.processors.equals(manager.processors) && this.restriction.equals((Object)manager.restriction);
    }

    @Nonnull
    public Project getProject() {
        return this.restriction.getProject();
    }

    @Nonnull
    public ProjectSettingsRestriction getRestriction() {
        return this.restriction;
    }

    public boolean hasProcessors() {
        return !this.processors.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.processors, this.restriction);
    }

    @Nonnull
    public RestrictionProcessingResult process(@Nonnull Set<Repository> repositories) {
        Objects.requireNonNull(repositories, "repositories");
        RestrictionProcessingResult.Builder processingResultBuilder = new RestrictionProcessingResult.Builder(this.restriction);
        processingResultBuilder.restrictionProcessed(true);
        if (repositories.isEmpty()) {
            return processingResultBuilder.build();
        }
        for (ProjectSettingsRestrictionProcessor processor : this.processors) {
            ProcessorInfo processorInfo = this.invokeProcessor(processor, repositories);
            processingResultBuilder.processor(processorInfo);
            if (processorInfo.getProcessorState() == ProcessorState.SUCCESS) continue;
            processingResultBuilder.restrictionProcessed(false);
        }
        return processingResultBuilder.build();
    }

    private ProcessorInfo invokeProcessor(ProjectSettingsRestrictionProcessor processor, Set<Repository> repositories) {
        String processorName = processor.getClass().getName();
        ProcessorInfo.Builder processorInfoBuilder = new ProcessorInfo.Builder(processor.getFeatureKey(), processor.getNamespace(), processorName);
        try {
            log.trace("{} processing {}", (Object)processorName, (Object)this.restriction.getProject());
            if (processor.process(new RestrictionProcessingRequest(repositories, this.restriction.getSettingsKey()))) {
                processorInfoBuilder.processorState(ProcessorState.SUCCESS);
                return processorInfoBuilder.build();
            }
            log.debug("{} failed to process for {}", (Object)processorName, (Object)this.restriction.getProject());
        }
        catch (Exception e) {
            log.error("{} threw exception while processing {}", new Object[]{processorName, this.restriction.getProject(), e});
        }
        processorInfoBuilder.processorState(ProcessorState.FAILED);
        return processorInfoBuilder.build();
    }
}

