/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction;

import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessor;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessorModuleDescriptor;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingManager;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectSettingsRestrictionProcessingManagerFactory {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public ProjectSettingsRestrictionProcessingManagerFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public ProjectSettingsRestrictionProcessingManager create(@Nonnull DmzProjectSettingsRestriction restriction) {
        Objects.requireNonNull(restriction, "restriction");
        List processors = (List)this.getProcessorStream(restriction.getSettingsKey()).collect(MoreCollectors.toImmutableList());
        return new ProjectSettingsRestrictionProcessingManager(restriction, processors);
    }

    public boolean hasProcessors(@Nonnull SettingsKey settingsKey) {
        return this.getProcessorStream(settingsKey).findFirst().isPresent();
    }

    private Stream<ProjectSettingsRestrictionProcessor> getProcessorStream(SettingsKey settingsKey) {
        return ModuleDescriptorUtils.toModules(this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectSettingsRestrictionProcessorModuleDescriptor.class).stream()).filter(module -> settingsKey.getFeatureKey().equals(module.getFeatureKey()) && settingsKey.getNamespace().equals(module.getNamespace()));
    }
}

