/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.config;

import com.atlassian.stash.internal.settingsrestriction.config.RestrictionProcessingConfigProvider;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.stereotype.Component;

@Component(value="restrictionProcessingConfigProvider")
public class DefaultRestrictionProcessingConfigProvider
implements RestrictionProcessingConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultRestrictionProcessingConfigProvider.class);
    private static final String CLEANUP_JOB_FIRST_RUN = "${settingsrestriction.processing.cleanupJobFirstRun:5m}";
    private static final String CLEANUP_JOB_INTERVAL = "${settingsrestriction.processing.cleanupJobInterval:24h}";
    private static final String CLEANUP_JOB_PROCESS_DELAY = "${settingsrestriction.processing.cleanupJobProcessDelay:1m}";
    private static final String INITIAL_DELAY = "${settingsrestriction.processing.initialDelay:2s}";
    private static final String IN_PROGRESS_EXPIRY_TIME = "${settingsrestriction.processing.retry.inProgressExpiryTime:24h}";
    private static final String MAX_PROCESSING_THREADS = "${settingsrestriction.processing.maxThreads}";
    private static final String MAX_RETRY_COUNT = "${settingsrestriction.processing.retry.maxCount:5}";
    private static final String MAX_RETRY_DELAY = "${settingsrestriction.processing.retry.maxDelay:30m}";
    private static final String MIN_RETRY_DELAY = "${settingsrestriction.processing.retry.minDelay:1m}";
    private static final String PROCESSING_BATCH_SIZE = "${settingsrestriction.processing.batchSize:1000}";
    private static final String REPOSITORY_BATCH_SIZE = "${settingsrestriction.processing.repoBatchSize:100}";
    private final Duration cleanupJobFirstRun;
    private final Duration cleanupJobInterval;
    private final Duration cleanupJobProcessDelay;
    private final Duration initialDelay;
    private final Duration inProgressExpiryTime;
    private final int maxProcessingThreads;
    private final int maxRetryCount;
    private final Duration maxRetryDelay;
    private final Duration minRetryDelay;
    private final int processingBatchSize;
    private final int repositoryBatchSize;

    @Autowired
    public DefaultRestrictionProcessingConfigProvider(@DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${settingsrestriction.processing.cleanupJobFirstRun:5m}") Duration cleanupJobFirstRun, @DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${settingsrestriction.processing.cleanupJobInterval:24h}") Duration cleanupJobInterval, @DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${settingsrestriction.processing.cleanupJobProcessDelay:1m}") Duration cleanupJobProcessDelay, @DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${settingsrestriction.processing.initialDelay:2s}") Duration initialDelay, @DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${settingsrestriction.processing.retry.inProgressExpiryTime:24h}") Duration inProgressExpiryTime, @Value(value="${settingsrestriction.processing.maxThreads}") String maxProcessingThreadsString, @Value(value="${settingsrestriction.processing.retry.maxCount:5}") int maxRetryCount, @DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${settingsrestriction.processing.retry.maxDelay:30m}") Duration maxRetryDelay, @DurationUnit(value=ChronoUnit.MINUTES) @Value(value="${settingsrestriction.processing.retry.minDelay:1m}") Duration minRetryDelay, @Value(value="${settingsrestriction.processing.batchSize:1000}") int processingBatchSize, @Value(value="${settingsrestriction.processing.repoBatchSize:100}") int repositoryBatchSize) {
        this(Runtime.getRuntime().availableProcessors(), cleanupJobFirstRun, cleanupJobInterval, cleanupJobProcessDelay, initialDelay, inProgressExpiryTime, maxProcessingThreadsString, maxRetryCount, maxRetryDelay, minRetryDelay, processingBatchSize, repositoryBatchSize);
    }

    @VisibleForTesting
    DefaultRestrictionProcessingConfigProvider(@Nonnull int availableProcessors, @Nonnull Duration cleanupJobFirstRun, @Nonnull Duration cleanupJobInterval, @Nonnull Duration cleanupJobProcessDelay, @Nonnull Duration initialDelay, @Nonnull Duration inProgressExpiryTime, @Nullable String maxProcessingThreadsString, int maxRetryCount, @Nonnull Duration maxRetryDelay, @Nonnull Duration minRetryDelay, int processingBatchSize, int repositoryBatchSize) {
        this.cleanupJobFirstRun = Objects.requireNonNull(cleanupJobFirstRun, "cleanupJobFirstRun");
        this.cleanupJobInterval = Objects.requireNonNull(cleanupJobInterval, "cleanupJobInterval");
        this.cleanupJobProcessDelay = Objects.requireNonNull(cleanupJobProcessDelay, "cleanupJobProcessDelay");
        this.initialDelay = Objects.requireNonNull(initialDelay, "initialDelay");
        this.inProgressExpiryTime = Objects.requireNonNull(inProgressExpiryTime, "inProgressExpiryTime");
        this.maxProcessingThreads = ExpressionUtils.parseExpressionAsInt((String)maxProcessingThreadsString).orElse(availableProcessors);
        this.maxRetryCount = maxRetryCount;
        this.maxRetryDelay = Objects.requireNonNull(maxRetryDelay, "maxRetryDelay");
        this.minRetryDelay = Objects.requireNonNull(minRetryDelay, "minRetryDelay");
        this.processingBatchSize = processingBatchSize;
        if (repositoryBatchSize < 1000 && repositoryBatchSize > 0) {
            this.repositoryBatchSize = repositoryBatchSize;
        } else {
            log.warn("settingsrestriction.processing.repoBatchSize is configured with an invalid value {}, using default of 100 instead", (Object)repositoryBatchSize);
            this.repositoryBatchSize = 100;
        }
    }

    @Override
    @Nonnull
    public Duration getCleanupJobFirstRun() {
        return this.cleanupJobFirstRun;
    }

    @Override
    @Nonnull
    public Duration getCleanupJobInterval() {
        return this.cleanupJobInterval;
    }

    @Override
    @Nonnull
    public Duration getCleanupJobProcessDelay() {
        return this.cleanupJobProcessDelay;
    }

    @Override
    @Nonnull
    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    @Override
    @Nonnull
    public Duration getInProgressExpiryTime() {
        return this.inProgressExpiryTime;
    }

    @Override
    public int getMaxProcessingThreads() {
        return this.maxProcessingThreads;
    }

    @Override
    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    @Override
    @Nonnull
    public Duration getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Override
    @Nonnull
    public Duration getMinRetryDelay() {
        return this.minRetryDelay;
    }

    @Override
    public int getProcessingBatchSize() {
        return this.processingBatchSize;
    }

    @Override
    public int getRepositoryBatchSize() {
        return this.repositoryBatchSize;
    }
}

