/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.event;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.settingsrestriction.event.ProjectSettingsRestrictionCreatedEvent;
import com.atlassian.stash.internal.settingsrestriction.event.ProjectSettingsRestrictionDeletedEvent;
import com.atlassian.stash.internal.settingsrestriction.event.ProjectSettingsRestrictionProcessRepositoryEvent;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="auditingProjectSettingsRestrictionEventListener")
public class AuditingProjectSettingsRestrictionEventListener {
    static final String ACTION_RESTRICTION_CREATED = "bitbucket.service.settingsrestriction.audit.action.created";
    static final String ACTION_RESTRICTION_DELETED = "bitbucket.service.settingsrestriction.audit.action.deleted";
    static final String ACTION_RESTRICTION_PROCESSREPO = "bitbucket.service.settingsrestriction.audit.action.processrepo";
    static final String ATTR_COMPONENT_KEY = "bitbucket.service.settingsrestriction.audit.attribute.componentkey";
    static final String ATTR_FEATURE_KEY = "bitbucket.service.settingsrestriction.audit.attribute.featurekey";
    static final String ATTR_NAMESPACE = "bitbucket.service.settingsrestriction.audit.attribute.namespace";
    private final AuditService auditService;

    public AuditingProjectSettingsRestrictionEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onProcessRepository(ProjectSettingsRestrictionProcessRepositoryEvent event) {
        DmzProjectSettingsRestriction restriction = event.getRestriction();
        this.auditService.audit(AuditEvent.builder((AuditType)this.getAction(ACTION_RESTRICTION_PROCESSREPO)).affectedObject(AuditUtils.auditResourceForRepository((Repository)event.getRepository())).extraAttributes(this.getExtraAttributes(restriction, ATTR_COMPONENT_KEY, ATTR_FEATURE_KEY, ATTR_NAMESPACE)).build());
    }

    @EventListener
    public void onProjectSettingsRestrictionCreated(ProjectSettingsRestrictionCreatedEvent event) {
        DmzProjectSettingsRestriction restriction = event.getRestriction();
        this.auditService.audit(AuditEvent.builder((AuditType)this.getAction(ACTION_RESTRICTION_CREATED)).affectedObject(AuditUtils.auditResourceForProject((Project)restriction.getProject())).extraAttributes(this.getExtraAttributes(restriction, ATTR_COMPONENT_KEY, ATTR_FEATURE_KEY, ATTR_NAMESPACE)).build());
    }

    @EventListener
    public void onProjectSettingsRestrictionDeleted(ProjectSettingsRestrictionDeletedEvent event) {
        DmzProjectSettingsRestriction restriction = event.getRestriction();
        this.auditService.audit(AuditEvent.builder((AuditType)this.getAction(ACTION_RESTRICTION_DELETED)).affectedObject(AuditUtils.auditResourceForProject((Project)restriction.getProject())).extraAttributes(this.getExtraAttributes(restriction, ATTR_COMPONENT_KEY, ATTR_FEATURE_KEY, ATTR_NAMESPACE)).build());
    }

    private AuditType getAction(String action) {
        return AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)action).build();
    }

    private List<AuditAttribute> getExtraAttributes(DmzProjectSettingsRestriction restriction, String attrComponentKey, String attrFeatureKey, String attrNamespace) {
        SettingsKey settingsKey = restriction.getSettingsKey();
        ImmutableList.Builder restrictionAttributes = ImmutableList.builder().add((Object)AuditAttribute.fromI18nKeys((String)attrFeatureKey, (String)settingsKey.getFeatureKey()).build());
        restrictionAttributes.add((Object)AuditAttribute.fromI18nKeys((String)attrNamespace, (String)settingsKey.getNamespace()).build());
        if (settingsKey.getComponentKey().isPresent()) {
            restrictionAttributes.add((Object)AuditAttribute.fromI18nKeys((String)attrComponentKey, (String)((String)settingsKey.getComponentKey().get())).build());
        }
        return restrictionAttributes.build();
    }
}

