/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.event;

import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

@TransactionAware
public class ProjectSettingsRestrictionEvent
extends ApplicationEvent {
    private static final String APPLICATION_INTERNAL_NAMESPACE = "com.atlassian.bitbucket.server:internal";
    private static final Set<SettingsKey> INTERNAL_SETTINGS_KEYS = ImmutableSet.of((Object)ProjectSettingsRestrictionKeys.ACCESS_KEYS, (Object)ProjectSettingsRestrictionKeys.ACCESS_TOKENS, (Object)ProjectSettingsRestrictionKeys.BRANCH_MODEL, (Object)ProjectSettingsRestrictionKeys.REPOSITORY_PERMISSIONS, (Object)ProjectSettingsRestrictionKeys.MERGE_STRATEGIES, (Object)ProjectSettingsRestrictionKeys.HOOKS, (Object[])new SettingsKey[]{ProjectSettingsRestrictionKeys.AUTO_MERGE});
    private final Project project;
    private final DmzProjectSettingsRestriction restriction;
    private final SettingsKey settingsKey;

    protected ProjectSettingsRestrictionEvent(@Nonnull Object source, @Nonnull Project project, @Nonnull DmzProjectSettingsRestriction restriction) {
        super(source);
        this.project = Objects.requireNonNull(project, "project");
        this.restriction = Objects.requireNonNull(restriction, "restriction");
        this.settingsKey = restriction.getSettingsKey();
    }

    @Nullable
    public String getComponentKey() {
        return this.settingsKey.getComponentKey().orElse(null);
    }

    @Nonnull
    public String getFeatureKey() {
        return this.normaliseSettingsKey(this.settingsKey);
    }

    @Nonnull
    public String getNamespace() {
        return this.normaliseNamespace(this.settingsKey);
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Nonnull
    public DmzProjectSettingsRestriction getRestriction() {
        return this.restriction;
    }

    private String normaliseNamespace(@Nonnull SettingsKey settingsKey) {
        if (APPLICATION_INTERNAL_NAMESPACE.equals(settingsKey.getNamespace())) {
            return APPLICATION_INTERNAL_NAMESPACE;
        }
        return "external";
    }

    private String normaliseSettingsKey(@Nonnull SettingsKey settingsKey) {
        Objects.requireNonNull(settingsKey, "settingsKey");
        if (INTERNAL_SETTINGS_KEYS.stream().anyMatch(value -> value.getFeatureKey().equals(settingsKey.getFeatureKey()) && value.getNamespace().equals(settingsKey.getNamespace()))) {
            return settingsKey.getFeatureKey();
        }
        return "external";
    }
}

