/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.event;

import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestriction;
import com.atlassian.bitbucket.event.repository.RepositoryModifiedEvent;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.settingsrestriction.ProjectSettingsRestrictionProcessingHelper;
import com.atlassian.stash.internal.settingsrestriction.config.RestrictionProcessingConfigProvider;
import com.atlassian.stash.internal.settingsrestriction.event.ProjectSettingsRestrictionCreatedEvent;
import com.atlassian.stash.internal.settingsrestriction.event.SettingsRestrictionProcessingFailedEvent;
import com.atlassian.stash.internal.settingsrestriction.scheduler.ProcessingRetryLimitExceededException;
import com.atlassian.stash.internal.settingsrestriction.scheduler.ProjectSettingsRestrictionProcessingScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DefaultApplicationMode
public class ProjectSettingsRestrictionEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectSettingsRestrictionEventListener.class);
    private final RestrictionProcessingConfigProvider configProvider;
    private final ProjectSettingsRestrictionProcessingHelper processingHelper;
    private final ProjectSettingsRestrictionProcessingScheduler processingScheduler;

    @Autowired
    public ProjectSettingsRestrictionEventListener(RestrictionProcessingConfigProvider configProvider, ProjectSettingsRestrictionProcessingHelper processingHelper, ProjectSettingsRestrictionProcessingScheduler processingScheduler) {
        this.configProvider = configProvider;
        this.processingHelper = processingHelper;
        this.processingScheduler = processingScheduler;
    }

    @EventListener
    public void onCreate(ProjectSettingsRestrictionCreatedEvent event) {
        if (event.hasProcessors()) {
            this.submitForProcessing(event.getRestriction());
        } else {
            log.debug("Not processing {} as it has no processors", (Object)event.getRestriction().getSettingsKey());
        }
    }

    @EventListener
    public void onProcessingFailed(SettingsRestrictionProcessingFailedEvent event) {
        this.submitForProcessing(event.getRestriction());
    }

    @EventListener
    public void onRepositoryModified(RepositoryModifiedEvent event) {
        Repository repository = event.getNewValue();
        if (event.isMoved() && repository.getProject().getType() != ProjectType.PERSONAL) {
            this.processingHelper.processRepository(repository);
        }
    }

    private void submitForProcessing(DmzProjectSettingsRestriction restriction) {
        try {
            this.processingScheduler.submitForProcessing(restriction, this.configProvider.getInitialDelay());
        }
        catch (ProcessingRetryLimitExceededException e) {
            log.error("Failed to retry processing for restriction", (Throwable)((Object)e));
        }
    }
}

