/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.processor;

import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessor;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessingRequest;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.merge.RepositoryMergeConfigDao;
import com.atlassian.stash.internal.pull.PullRequestMergeConfigBulkDeletedEvent;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="mergeConfigSettingsRestrictionProcessor")
public class MergeConfigSettingsRestrictionProcessor
implements ProjectSettingsRestrictionProcessor {
    private static final Logger log = LoggerFactory.getLogger(MergeConfigSettingsRestrictionProcessor.class);
    private final EventPublisher eventPublisher;
    private final RepositoryMergeConfigDao repositoryMergeConfigDao;

    @Autowired
    public MergeConfigSettingsRestrictionProcessor(EventPublisher eventPublisher, RepositoryMergeConfigDao repositoryMergeConfigDao) {
        this.eventPublisher = eventPublisher;
        this.repositoryMergeConfigDao = repositoryMergeConfigDao;
    }

    @Nonnull
    public String getFeatureKey() {
        return ProjectSettingsRestrictionKeys.MERGE_STRATEGIES.getFeatureKey();
    }

    @Nonnull
    public String getNamespace() {
        return ProjectSettingsRestrictionKeys.MERGE_STRATEGIES.getNamespace();
    }

    @Transactional
    public boolean process(@Nonnull RestrictionProcessingRequest processingRequest) {
        log.trace("Deleting repository merge configurations for request {}", (Object)processingRequest);
        if (processingRequest.getRepositories().isEmpty()) {
            log.trace("No repos to process {}", (Object)processingRequest);
            return true;
        }
        Project project = ((Repository)processingRequest.getRepositories().iterator().next()).getProject();
        Set repositoryIds = (Set)processingRequest.getRepositories().stream().map(Repository::getId).collect(ImmutableSet.toImmutableSet());
        try (Ticker ignored = Timers.timer((String)String.format("MergeConfigSettingsRestrictionProcessor: Processing restrictions for %s repositories", repositoryIds.size())).start(new Object[]{project.getId()});){
            int mergeConfigsDeleted = this.repositoryMergeConfigDao.deleteByRepositories(repositoryIds);
            this.eventPublisher.publish((Object)new PullRequestMergeConfigBulkDeletedEvent(this, "git", project, mergeConfigsDeleted));
            log.trace("Successfully deleted {} repository merge configurations for request {}", (Object)mergeConfigsDeleted, (Object)processingRequest);
        }
        return true;
    }
}

