/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.settingsrestriction.result;

import com.atlassian.stash.internal.settingsrestriction.result.ProcessorState;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ProcessorInfo {
    private final String featureKey;
    private final String namespace;
    private final String processorName;
    private final ProcessorState processorState;

    private ProcessorInfo(Builder builder) {
        this.featureKey = builder.featureKey;
        this.namespace = builder.namespace;
        this.processorName = builder.processorName;
        this.processorState = builder.processorState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorInfo that = (ProcessorInfo)o;
        return this.featureKey.equals(that.featureKey) && this.namespace.equals(that.namespace) && this.processorName.equals(that.processorName) && this.processorState == that.processorState;
    }

    @Nonnull
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public String getProcessorName() {
        return this.processorName;
    }

    @Nonnull
    public ProcessorState getProcessorState() {
        return this.processorState;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureKey, this.namespace, this.processorName, this.processorState});
    }

    public static class Builder {
        private final String featureKey;
        private final String namespace;
        private final String processorName;
        private ProcessorState processorState;

        public Builder(@Nonnull String featureKey, @Nonnull String namespace, @Nonnull String processorName) {
            this.featureKey = Objects.requireNonNull(featureKey, "featureKey");
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.processorName = Objects.requireNonNull(processorName, "processorName");
            this.processorState = ProcessorState.PENDING;
        }

        @Nonnull
        public ProcessorInfo build() {
            return new ProcessorInfo(this);
        }

        @Nonnull
        public Builder processorState(@Nonnull ProcessorState processorState) {
            this.processorState = Objects.requireNonNull(processorState, "processorState");
            return this;
        }
    }
}

